/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.all.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import java.util.HashMap;
import org.apache.ozhera.prometheus.all.client.MetricsManager;
import org.apache.ozhera.prometheus.all.client.Prometheus;
import org.apache.ozhera.prometheus.all.client.XmCounter;
import org.apache.ozhera.prometheus.all.client.XmGauge;
import org.apache.ozhera.prometheus.all.client.XmHistogram;
import org.apache.ozhera.prometheus.all.client.binder.ClassLoaderMetricsReduced;
import org.apache.ozhera.prometheus.all.client.binder.JvmGcMetricsReduced;
import org.apache.ozhera.prometheus.all.client.binder.JvmMemoryMetricsReduced;
import org.apache.ozhera.prometheus.all.client.binder.JvmThreadMetricsReduced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    public MetricsManager gMetricsMgr;
    public static final String GROUP = "group";
    public static final String SERVICE = "service";
    public static final String APPLICATION = "application";
    public static double[] DEFAULT_LATENCY_BUCKETS = new double[]{0.01, 0.05, 1.0, 5.0, 7.5, 10.0, 25.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};

    public void init(String group, String service) {
        this.init(group, service, false);
    }

    public void init(String group, String service, boolean jvmReduced) {
        this.setGroup(group);
        this.setService(service);
        Prometheus.REGISTRY.config().commonTags(new String[]{APPLICATION, Prometheus.constLabels.get(SERVICE)});
        if (jvmReduced) {
            new ClassLoaderMetricsReduced().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmMemoryMetricsReduced().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmGcMetricsReduced().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new ProcessorMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmThreadMetricsReduced().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new UptimeMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new FileDescriptorMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
        } else {
            new ClassLoaderMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmMemoryMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmGcMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new ProcessorMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new JvmThreadMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new UptimeMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
            new FileDescriptorMetrics().bindTo((MeterRegistry)Prometheus.REGISTRY);
        }
    }

    public static Metrics getInstance() {
        return LazyHolder.ins;
    }

    public void setGroup(String group) {
        Prometheus.constLabels.put(GROUP, group);
    }

    public void setService(String service) {
        Prometheus.constLabels.put(SERVICE, service);
    }

    private Metrics() {
        Prometheus.constLabels = new HashMap<String, String>();
        this.gMetricsMgr = new Prometheus();
    }

    public XmCounter newCounter(String metricName, String ... labelNames) {
        try {
            return this.gMetricsMgr.newCounter(metricName, labelNames);
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    public XmGauge newGauge(String metricName, String ... labelNames) {
        return this.gMetricsMgr.newGauge(metricName, labelNames);
    }

    public XmHistogram newHistogram(String metricName, double[] buckets, String ... labelNames) {
        if (buckets != null && buckets.length > 0) {
            return this.gMetricsMgr.newHistogram(metricName, buckets, labelNames);
        }
        return this.gMetricsMgr.newHistogram(metricName, DEFAULT_LATENCY_BUCKETS, labelNames);
    }

    private static class LazyHolder {
        private static final Metrics ins = new Metrics();

        private LazyHolder() {
        }
    }
}

