/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.qps;

import com.xiaomi.youpin.qps.Qps;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Aspect
@Configuration
@Order(value=-1)
public class QpsAop {
    private static final Logger log = LoggerFactory.getLogger(QpsAop.class);
    private AtomicLong qpsNum = new AtomicLong();
    private AtomicLong num = new AtomicLong();
    private ConcurrentHashMap<String, AtomicLong> qpsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> map = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                this.num.set(this.qpsNum.get());
                this.qpsNum.set(0L);
                this.map.putAll(this.qpsMap);
                Set<String> rmKeys = this.map.keySet().stream().filter(it -> !this.qpsMap.containsKey(it)).collect(Collectors.toSet());
                rmKeys.forEach(it -> this.map.remove(it));
                this.qpsMap.clear();
            }
            catch (Throwable ex) {
                log.info("error:{}", (Object)ex.getMessage());
            }
        }, 5L, 1L, TimeUnit.SECONDS);
    }

    @Around(value="@annotation(qps)")
    public Object qps(ProceedingJoinPoint joinPoint, Qps qps) throws Throwable {
        this.qpsNum.incrementAndGet();
        return joinPoint.proceed();
    }

    public void incr() {
        this.qpsNum.incrementAndGet();
    }

    public void incr(String name) {
        this.qpsNum.incrementAndGet();
        this.qpsMap.compute(name, (s, atomicLong) -> {
            if (null == atomicLong) {
                return new AtomicLong(1L);
            }
            atomicLong.incrementAndGet();
            return atomicLong;
        });
    }

    public long getQps() {
        return this.num.get();
    }

    public long getQps(String name) {
        return this.map.getOrDefault(name, new AtomicLong(0L)).get();
    }
}

