/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.configuration;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Configuration;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.common.Pair;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.ioc.BeanAnnoProcessor;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.config.ConfigUtils;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin(order=0x7FFFFFFD)
public class ConfigurationPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPlugin.class);

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        classSet.stream().filter(this::filterConfigurationClass).forEach(it -> BeanAnnoProcessor.process((Object)this.makeConfigurationInstance((Class<?>)it, ioc), (Ioc)ioc));
    }

    private boolean filterConfigurationClass(Class<?> it) {
        return Optional.ofNullable(it).map(it2 -> it2.getAnnotation(Configuration.class)).isPresent();
    }

    private Object makeConfigurationInstance(Class<?> configuration, Ioc ioc) {
        Object cInstance = ReflectUtils.getInstance(configuration);
        Config config = (Config)ioc.getBean(Config.class);
        this.injectValue(cInstance, config);
        return cInstance;
    }

    private void injectValue(Object cInstance, Config config) {
        if (null == config) {
            log.warn("config class is null, @Configuration:{} no need to inject @Value", cInstance.getClass());
            return;
        }
        Class<?> configuration = cInstance.getClass();
        Field[] fields = ReflectUtils.fields(configuration);
        Arrays.stream(fields).forEach(f -> {
            Optional<Value> optional = Optional.ofNullable(f.getAnnotation(Value.class));
            if (optional.isPresent()) {
                String realValue = null;
                Value value = optional.get();
                String v = value.value();
                String dv = value.defaultValue();
                if (v.startsWith("${")) {
                    Pair elPair = ConfigUtils.parseElKey((String)v, (String)dv);
                    realValue = config.get((String)elPair.getKey(), (String)elPair.getValue());
                } else {
                    realValue = config.get(v, dv);
                }
                ReflectUtils.setField((Object)cInstance, (Field)f, (Object)realValue);
            }
        });
    }
}

