/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.encrypt;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.nutz.lang.Lang;

public class MsgDigestInputStream
extends FilterInputStream {
    private MessageDigest md;

    public MsgDigestInputStream(InputStream in, MessageDigest md) {
        super(in);
        this.md = md;
    }

    public MsgDigestInputStream(InputStream in, String name) {
        super(in);
        try {
            this.md = MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw Lang.wrapThrow(e);
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        this.md.update((byte)b);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.in.read(b);
        if (-1 != len) {
            this.md.update(b, 0, len);
        }
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int len2 = this.in.read(b, off, len);
        this.md.update(b, off, len2);
        return len2;
    }

    public String digest() {
        return Lang.fixedHexString(this.md.digest());
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.md.reset();
    }
}

