/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.common.util;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.nacos.NacosConfig;
import com.xiaomi.youpin.docean.plugin.nacos.NacosNaming;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);
    public static final String DEFAULT_SERVER_PORT = "7789";
    private static final String DEFAULT_TIME_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String STREAM_VERSION = "hera-log-stream:1.0.0:2023-02-23";
    private static final String LOCAL_IP_KEY = "localIp";
    private static final String TESLA_HOST_KEY = "TESLA_HOST";

    private StreamUtils() {
    }

    public static NacosNaming getNacosNaming(String nacosAddress) {
        NacosNaming nacosNaming = new NacosNaming();
        nacosNaming.setServerAddr(nacosAddress);
        nacosNaming.init();
        return nacosNaming;
    }

    public static Instance buildInstance(String serviceName) {
        Instance instance = new Instance();
        instance.setEnabled(true);
        instance.setHealthy(true);
        instance.setIp(StreamUtils.getIp());
        instance.setPort(Integer.parseInt(Config.ins().get("service_port", DEFAULT_SERVER_PORT)));
        instance.setServiceName(serviceName);
        HashMap metaData = Maps.newHashMap();
        metaData.put("ctime", new SimpleDateFormat(DEFAULT_TIME_DATE_FORMAT).format(new Date()));
        metaData.put("version", STREAM_VERSION);
        metaData.put("MONE_CONTAINER_S_POD_NAME", System.getenv("MONE_CONTAINER_S_POD_NAME"));
        SafeRun.run(() -> metaData.put("hostname", InetAddress.getLocalHost().getHostName()));
        instance.setMetadata((Map)metaData);
        return instance;
    }

    public static String getIp() {
        return System.getenv(TESLA_HOST_KEY) == null ? NetUtils.getLocalHost() : System.getenv(TESLA_HOST_KEY);
    }

    public static String getLocalIp() {
        String localIp = Config.ins().get(LOCAL_IP_KEY, "");
        String containerIp = System.getenv(TESLA_HOST_KEY) == null ? NetUtils.getLocalHost() : System.getenv(TESLA_HOST_KEY);
        log.info("localIP:{},{}", (Object)localIp, (Object)containerIp);
        if (StringUtils.isNotEmpty((String)localIp)) {
            return localIp;
        }
        return containerIp;
    }

    public static String getCurrentMachineMark() {
        String containerPodName = System.getenv("MONE_CONTAINER_S_POD_NAME");
        if (StringUtils.isNotBlank((String)containerPodName)) {
            return org.apache.commons.lang3.StringUtils.substringAfterLast((String)containerPodName, (String)"-");
        }
        return StreamUtils.getLocalIp();
    }

    public static NacosConfig getConfigFromNacos() {
        NacosConfig nacosConfig = new NacosConfig();
        nacosConfig.setDataId(Config.ins().get("nacos_config_dataid", ""));
        nacosConfig.setGroup(Config.ins().get("nacos_config_group", "DEFAULT_GROUP"));
        nacosConfig.setServerAddr(Config.ins().get("nacos_config_server_addr", ""));
        nacosConfig.init();
        nacosConfig.forEach((k, v) -> Config.ins().set(k, v));
        return nacosConfig;
    }

    public static JdbcInfo extractInfoFromJdbcUrl(String jdbcUrl) {
        String regex = "//([^:/]+)(:\\d+)?/([^?/]+)(\\?.*)?";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(jdbcUrl);
        if (matcher.find()) {
            String ip = matcher.group(1);
            String port = matcher.group(2);
            String dbName = matcher.group(3);
            return new JdbcInfo(ip, port, dbName);
        }
        throw new IllegalArgumentException("Invalid JDBC URL: " + jdbcUrl);
    }

    public static class JdbcInfo {
        private final String ip;
        private final String port;
        private final String dbName;

        public JdbcInfo(String ip, String port, String dbName) {
            this.ip = ip;
            this.port = port;
            this.dbName = dbName;
        }

        public String getIp() {
            return this.ip;
        }

        public String getPort() {
            return this.port;
        }

        public String getDbName() {
            return this.dbName;
        }
    }
}

