/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.config;

import com.alibaba.nacos.api.config.listener.Listener;
import com.google.gson.Gson;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import com.xiaomi.youpin.docean.plugin.nacos.NacosConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.apache.ozhera.log.stream.common.util.StreamUtils;
import org.apache.ozhera.log.stream.config.MilogConfigListener;
import org.apache.ozhera.log.stream.exception.StreamException;
import org.apache.ozhera.log.stream.job.extension.StreamCommonExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    @Resource
    private NacosConfig nacosConfig;
    @Value(value="$hera.stream.monitor_space_data_id")
    private String spaceDataId;
    private ConcurrentHashMap<Long, MilogConfigListener> listeners = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, MilogSpaceData> milogSpaceDataMap = new ConcurrentHashMap();
    private Gson gson = new Gson();
    private ReentrantLock spaceLock = new ReentrantLock();
    private static ExecutorService THREAD_POOL = Executors.newVirtualThreadPerTaskExecutor();

    public void initializeStreamConfig() throws StreamException {
        log.debug("[initStream} nacos dataId:{},group:{}", (Object)this.spaceDataId, (Object)"DEFAULT_GROUP");
        String streamConfigStr = this.nacosConfig.getConfigStr(this.spaceDataId, "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
        try {
            if (!StringUtils.isNotEmpty((String)streamConfigStr) || "null".equals(streamConfigStr)) {
                log.warn("[ConfigManager.initConfigManager] Nacos configuration [dataID:{},group:{}]not found,exit initConfigManager", (Object)this.spaceDataId, (Object)"DEFAULT_GROUP");
                return;
            }
            MiLogStreamConfig milogStreamConfig = (MiLogStreamConfig)Constant.GSON.fromJson(streamConfigStr, MiLogStreamConfig.class);
            String uniqueMark = StreamUtils.getCurrentMachineMark();
            Map config = milogStreamConfig.getConfig();
            if (config.containsKey(uniqueMark)) {
                Map milogStreamDataMap = (Map)config.get(uniqueMark);
                log.info("[ConfigManager.initConfigManager] uniqueMark:{},data:{}", (Object)uniqueMark, (Object)this.gson.toJson((Object)milogStreamDataMap));
                for (Long spaceId : milogStreamDataMap.keySet()) {
                    MilogSpaceData milogSpaceData;
                    String dataId = (String)milogStreamDataMap.get(spaceId);
                    String logSpaceDataStr = this.nacosConfig.getConfigStr(dataId, "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
                    if (!StringUtils.isNotEmpty((String)logSpaceDataStr) || null == (milogSpaceData = (MilogSpaceData)Constant.GSON.fromJson(logSpaceDataStr, MilogSpaceData.class)) || this.milogSpaceDataMap.containsKey(spaceId)) continue;
                    MilogConfigListener configListener = new MilogConfigListener(spaceId, dataId, "DEFAULT_GROUP", milogSpaceData, this.nacosConfig);
                    this.addListener(spaceId, configListener);
                    this.milogSpaceDataMap.put(spaceId, milogSpaceData);
                    log.info("[ConfigManager.initStream] added log config listener for spaceId:{},dataId:{}", (Object)spaceId, (Object)dataId);
                }
            } else {
                log.info("server start current not contain space config,uniqueMark:{}", (Object)uniqueMark);
            }
        }
        catch (Exception e) {
            log.error("[ConfigManager.initStream] initStream exec err", (Throwable)e);
        }
    }

    public void addListener(Long spaceId, MilogConfigListener listener) {
        this.listeners.put(spaceId, listener);
    }

    public void listenLogStreamConfig() {
        this.nacosConfig.addListener(this.spaceDataId, "DEFAULT_GROUP", new Listener(){

            public Executor getExecutor() {
                return THREAD_POOL;
            }

            public void receiveConfigInfo(String spaceStr) {
                try {
                    MiLogStreamConfig milogStreamConfig = (MiLogStreamConfig)Constant.GSON.fromJson(spaceStr, MiLogStreamConfig.class);
                    ConfigManager.this.handleMiLogStreamConfig(milogStreamConfig);
                }
                catch (Exception e) {
                    log.error("Error deserializing MiLogStreamConfig,spaceStr:{}", (Object)spaceStr, (Object)e);
                }
            }
        });
    }

    private void handleMiLogStreamConfig(MiLogStreamConfig milogStreamConfig) {
        String uniqueMark = StreamUtils.getCurrentMachineMark();
        log.info("listening namespace received a configuration request,{},uniqueMark:{}", (Object)this.gson.toJson((Object)milogStreamConfig), (Object)uniqueMark);
        if (milogStreamConfig != null) {
            Map config = milogStreamConfig.getConfig();
            if (config != null) {
                this.processConfigForUniqueMark(uniqueMark, config);
            } else {
                log.warn("listen dataID:{},groupId:{},but receive config is empty", (Object)this.spaceDataId, (Object)"DEFAULT_GROUP");
            }
        } else {
            log.warn("listen dataID:{},groupId:{},but receive info is null", (Object)this.spaceDataId, (Object)"DEFAULT_GROUP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigForUniqueMark(String uniqueMark, Map<String, Map<Long, String>> config) {
        StreamCommonExtension extensionInstance = this.getStreamCommonExtensionInstance();
        if (!extensionInstance.checkUniqueMarkExists(uniqueMark, config).booleanValue()) {
            log.warn("listen dataID:{},groupId:{},but receive config is empty", (Object)this.spaceDataId, (Object)"DEFAULT_GROUP");
            return;
        }
        Map<Long, String> dataIdMap = extensionInstance.getConfigMapByUniqueMark(config, uniqueMark);
        if (this.spaceLock.tryLock()) {
            try {
                this.stopUnusefulListenerAndJob(dataIdMap);
                this.startNewListenerAndJob(dataIdMap);
            }
            finally {
                this.spaceLock.unlock();
            }
        } else {
            log.warn("Failed to acquire lock, skipping processing for dataIdMap: {}", dataIdMap);
        }
    }

    private StreamCommonExtension getStreamCommonExtensionInstance() {
        String factualServiceName = Config.ins().get("common.stream.extension", "defaultCommonStreamExtension");
        return (StreamCommonExtension)Ioc.ins().getBean(factualServiceName);
    }

    public boolean existListener(Long spaceId) {
        return this.milogSpaceDataMap.containsKey(spaceId);
    }

    public List<Long> unUseFilter(Map<Long, String> newLogStreamDataMap) {
        ArrayList<Long> unUseSpaceIds = new ArrayList<Long>(this.milogSpaceDataMap.keySet());
        unUseSpaceIds.removeIf(newLogStreamDataMap::containsKey);
        return unUseSpaceIds;
    }

    public void stopUnusefulListenerAndJob(Map<Long, String> milogStreamDataMap) {
        List<Long> unUseSpaceIds = this.unUseFilter(milogStreamDataMap);
        if (CollectionUtils.isEmpty(unUseSpaceIds)) {
            return;
        }
        this.logUnusefulSpaceIds(unUseSpaceIds);
        unUseSpaceIds.forEach(this::stopAndRemoveListenerAndJob);
    }

    private void logUnusefulSpaceIds(List<Long> unUseSpaceIds) {
        log.info("[listening namespace] The space ID that needs to be stopped: {}", (Object)this.gson.toJson(unUseSpaceIds));
        this.logExistingListeners();
    }

    private void logExistingListeners() {
        ArrayList listenerKeys = new ArrayList(this.listeners.keySet());
        log.info("[listening namespace] all listeners already exist: {}", (Object)this.gson.toJson(listenerKeys));
    }

    private void stopAndRemoveListenerAndJob(Long stopSpaceId) {
        MilogConfigListener spaceConfigListener = this.listeners.get(stopSpaceId);
        if (spaceConfigListener != null) {
            log.info("stopping the space ID: {}", (Object)stopSpaceId);
            spaceConfigListener.shutdown();
            log.info("Removing stopSpaceId: {} log tail config listener", (Object)stopSpaceId);
            this.listeners.remove(stopSpaceId);
        } else {
            log.warn("No space ID in the current listener is ready to be stopped: {}", (Object)stopSpaceId);
        }
        this.stopJob(stopSpaceId, spaceConfigListener);
    }

    private void stopJob(Long stopSpaceId, MilogConfigListener spaceConfigListener) {
        MilogSpaceData milogSpaceData = this.milogSpaceDataMap.get(stopSpaceId);
        if (milogSpaceData != null) {
            spaceConfigListener.getJobManager().closeJobs(milogSpaceData);
            log.info("Closing stopSpaceId: {} logTail consumer job", (Object)stopSpaceId);
        } else {
            log.warn("Milog space config cache for spaceId: {}, unuseful job, needed to be closed, but is null", (Object)stopSpaceId);
        }
        this.milogSpaceDataMap.remove(stopSpaceId);
    }

    public void startNewListenerAndJob(Map<Long, String> milogStreamDataMap) {
        milogStreamDataMap.forEach((spaceId, dataId) -> {
            if (!this.existListener((Long)spaceId)) {
                log.info("startNewListenerAndJob for spaceId:{}", spaceId);
                MilogSpaceData milogSpaceData = this.getMilogSpaceData((String)dataId);
                MilogConfigListener configListener = new MilogConfigListener((Long)spaceId, (String)dataId, "DEFAULT_GROUP", milogSpaceData, this.nacosConfig);
                this.addListener((Long)spaceId, configListener);
                this.milogSpaceDataMap.put((Long)spaceId, milogSpaceData);
            }
        });
    }

    private MilogSpaceData getMilogSpaceData(String dataId) {
        try {
            String logSpaceDataStr = this.nacosConfig.getConfigStr(dataId, "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
            return StringUtils.isNotEmpty((String)logSpaceDataStr) ? (MilogSpaceData)Constant.GSON.fromJson(logSpaceDataStr, MilogSpaceData.class) : new MilogSpaceData();
        }
        catch (Exception e) {
            log.error("Failed to get MilogSpaceData for dataId: {}", (Object)dataId, (Object)e);
            return new MilogSpaceData();
        }
    }

    public ConcurrentHashMap<Long, MilogSpaceData> getMilogSpaceDataMap() {
        return this.milogSpaceDataMap;
    }

    public ConcurrentHashMap<Long, MilogConfigListener> getListeners() {
        return this.listeners;
    }
}

