/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.kafka;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.extension.MQPlugin;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaConfig;
import org.apache.ozhera.log.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPlugin
implements MQPlugin {
    private static final Logger log = LoggerFactory.getLogger(KafkaPlugin.class);

    public static KafkaConfig buildKafkaConfig(String userName, String password, String clusterInfo, String topic, String tag, String consumerGroup, SinkJobEnum jobType) {
        KafkaConfig config = new KafkaConfig();
        config.setNamesAddr(clusterInfo);
        config.setUserName(userName);
        config.setPassword(password);
        config.setConsumerGroup((String)(StringUtils.isEmpty((CharSequence)consumerGroup) ? "subGroup_" + tag : consumerGroup));
        if (SinkJobEnum.BACKUP_JOB == jobType) {
            config.setConsumerGroup("subGroup_" + tag + "_backup");
        }
        config.setTopicName(topic);
        config.setTag(tag);
        log.info("[KafkaPlugin.initJob] print consumer config:{}", (Object)config);
        return config;
    }

    public static KafkaConsumer<String, String> getKafkaConsumer(KafkaConfig config) {
        return KafkaPlugin.initKafkaConsumer(config);
    }

    public static KafkaConsumer<String, String> initKafkaConsumer(KafkaConfig config) {
        Properties props = new Properties();
        String clusterInfo = config.getNamesAddr();
        String userName = config.getUserName();
        String password = config.getPassword();
        Config ins = Config.ins();
        String kafkaUseSsl = ins.get("kafka.use.ssl", "false");
        String kafkaSllLocation = ins.get("kafka.sll.location", "");
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password) && Objects.equals("true", kafkaUseSsl)) {
            props.putAll((Map<?, ?>)KafkaUtils.getSslKafkaProperties((String)clusterInfo, (String)userName, (String)password, (String)kafkaSllLocation));
        } else if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
            props.putAll((Map<?, ?>)KafkaUtils.getVpc9094KafkaProperties((String)clusterInfo, (String)userName, (String)password));
        } else {
            props.putAll((Map<?, ?>)KafkaUtils.getDefaultKafkaProperties((String)clusterInfo));
        }
        props.put("session.timeout.ms", (Object)30000);
        props.put("max.poll.records", (Object)30);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("group.id", config.getConsumerGroup());
        props.put("ssl.endpoint.identification.algorithm", "");
        return new KafkaConsumer(props);
    }
}

