/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ozhera.operator.bo.PropConf;
import org.apache.ozhera.operator.common.FileUtils;
import org.apache.ozhera.operator.service.IResource;

public class HeraResource
implements IResource {
    private Boolean needCreate = true;
    private Boolean required = true;
    private String resourceType;
    private String resourceName;
    private String defaultYamlPath;
    private String yamlStr;
    private List<Map<String, String>> connectionMapList;
    private String remark;
    private List<PropConf> propList;
    private String[] defaultExtendConfigPath;

    @Override
    public String readResource(String path) {
        Objects.nonNull(path);
        return FileUtils.readResourceFile((String)path);
    }

    public void setDefaultYaml() {
        this.setYamlStr(this.readResource(this.defaultYamlPath));
    }

    public void setDefaultExtendConfig() {
        if (null == this.defaultExtendConfigPath || this.defaultExtendConfigPath.length == 0) {
            return;
        }
        if (null == this.propList) {
            this.propList = new ArrayList<PropConf>();
        }
        for (String p : this.defaultExtendConfigPath) {
            PropConf propConf = new PropConf();
            String key = p.substring(p.lastIndexOf("/") + 1, p.lastIndexOf("."));
            String config = this.readResource(p);
            propConf.setKey(key);
            propConf.setValue(config);
            this.propList.add(propConf);
        }
    }

    public static HeraResourceBuilder builder() {
        return new HeraResourceBuilder();
    }

    public Boolean getNeedCreate() {
        return this.needCreate;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getDefaultYamlPath() {
        return this.defaultYamlPath;
    }

    public String getYamlStr() {
        return this.yamlStr;
    }

    public List<Map<String, String>> getConnectionMapList() {
        return this.connectionMapList;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<PropConf> getPropList() {
        return this.propList;
    }

    public String[] getDefaultExtendConfigPath() {
        return this.defaultExtendConfigPath;
    }

    public void setNeedCreate(Boolean needCreate) {
        this.needCreate = needCreate;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setDefaultYamlPath(String defaultYamlPath) {
        this.defaultYamlPath = defaultYamlPath;
    }

    public void setYamlStr(String yamlStr) {
        this.yamlStr = yamlStr;
    }

    public void setConnectionMapList(List<Map<String, String>> connectionMapList) {
        this.connectionMapList = connectionMapList;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setPropList(List<PropConf> propList) {
        this.propList = propList;
    }

    public void setDefaultExtendConfigPath(String[] defaultExtendConfigPath) {
        this.defaultExtendConfigPath = defaultExtendConfigPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeraResource)) {
            return false;
        }
        HeraResource other = (HeraResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$needCreate = this.getNeedCreate();
        Boolean other$needCreate = other.getNeedCreate();
        if (this$needCreate == null ? other$needCreate != null : !((Object)this$needCreate).equals(other$needCreate)) {
            return false;
        }
        Boolean this$required = this.getRequired();
        Boolean other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        String this$defaultYamlPath = this.getDefaultYamlPath();
        String other$defaultYamlPath = other.getDefaultYamlPath();
        if (this$defaultYamlPath == null ? other$defaultYamlPath != null : !this$defaultYamlPath.equals(other$defaultYamlPath)) {
            return false;
        }
        String this$yamlStr = this.getYamlStr();
        String other$yamlStr = other.getYamlStr();
        if (this$yamlStr == null ? other$yamlStr != null : !this$yamlStr.equals(other$yamlStr)) {
            return false;
        }
        List<Map<String, String>> this$connectionMapList = this.getConnectionMapList();
        List<Map<String, String>> other$connectionMapList = other.getConnectionMapList();
        if (this$connectionMapList == null ? other$connectionMapList != null : !((Object)this$connectionMapList).equals(other$connectionMapList)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        List<PropConf> this$propList = this.getPropList();
        List<PropConf> other$propList = other.getPropList();
        if (this$propList == null ? other$propList != null : !((Object)this$propList).equals(other$propList)) {
            return false;
        }
        return Arrays.deepEquals(this.getDefaultExtendConfigPath(), other.getDefaultExtendConfigPath());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeraResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $needCreate = this.getNeedCreate();
        result = result * 59 + ($needCreate == null ? 43 : ((Object)$needCreate).hashCode());
        Boolean $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        String $defaultYamlPath = this.getDefaultYamlPath();
        result = result * 59 + ($defaultYamlPath == null ? 43 : $defaultYamlPath.hashCode());
        String $yamlStr = this.getYamlStr();
        result = result * 59 + ($yamlStr == null ? 43 : $yamlStr.hashCode());
        List<Map<String, String>> $connectionMapList = this.getConnectionMapList();
        result = result * 59 + ($connectionMapList == null ? 43 : ((Object)$connectionMapList).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        List<PropConf> $propList = this.getPropList();
        result = result * 59 + ($propList == null ? 43 : ((Object)$propList).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultExtendConfigPath());
        return result;
    }

    public String toString() {
        return "HeraResource(needCreate=" + this.getNeedCreate() + ", required=" + this.getRequired() + ", resourceType=" + this.getResourceType() + ", resourceName=" + this.getResourceName() + ", defaultYamlPath=" + this.getDefaultYamlPath() + ", yamlStr=" + this.getYamlStr() + ", connectionMapList=" + String.valueOf(this.getConnectionMapList()) + ", remark=" + this.getRemark() + ", propList=" + String.valueOf(this.getPropList()) + ", defaultExtendConfigPath=" + Arrays.deepToString(this.getDefaultExtendConfigPath()) + ")";
    }

    public HeraResource() {
    }

    public HeraResource(Boolean needCreate, Boolean required, String resourceType, String resourceName, String defaultYamlPath, String yamlStr, List<Map<String, String>> connectionMapList, String remark, List<PropConf> propList, String[] defaultExtendConfigPath) {
        this.needCreate = needCreate;
        this.required = required;
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.defaultYamlPath = defaultYamlPath;
        this.yamlStr = yamlStr;
        this.connectionMapList = connectionMapList;
        this.remark = remark;
        this.propList = propList;
        this.defaultExtendConfigPath = defaultExtendConfigPath;
    }

    public static class HeraResourceBuilder {
        private Boolean needCreate;
        private Boolean required;
        private String resourceType;
        private String resourceName;
        private String defaultYamlPath;
        private String yamlStr;
        private List<Map<String, String>> connectionMapList;
        private String remark;
        private List<PropConf> propList;
        private String[] defaultExtendConfigPath;

        HeraResourceBuilder() {
        }

        public HeraResourceBuilder needCreate(Boolean needCreate) {
            this.needCreate = needCreate;
            return this;
        }

        public HeraResourceBuilder required(Boolean required) {
            this.required = required;
            return this;
        }

        public HeraResourceBuilder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public HeraResourceBuilder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public HeraResourceBuilder defaultYamlPath(String defaultYamlPath) {
            this.defaultYamlPath = defaultYamlPath;
            return this;
        }

        public HeraResourceBuilder yamlStr(String yamlStr) {
            this.yamlStr = yamlStr;
            return this;
        }

        public HeraResourceBuilder connectionMapList(List<Map<String, String>> connectionMapList) {
            this.connectionMapList = connectionMapList;
            return this;
        }

        public HeraResourceBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public HeraResourceBuilder propList(List<PropConf> propList) {
            this.propList = propList;
            return this;
        }

        public HeraResourceBuilder defaultExtendConfigPath(String[] defaultExtendConfigPath) {
            this.defaultExtendConfigPath = defaultExtendConfigPath;
            return this;
        }

        public HeraResource build() {
            return new HeraResource(this.needCreate, this.required, this.resourceType, this.resourceName, this.defaultYamlPath, this.yamlStr, this.connectionMapList, this.remark, this.propList, this.defaultExtendConfigPath);
        }

        public String toString() {
            return "HeraResource.HeraResourceBuilder(needCreate=" + this.needCreate + ", required=" + this.required + ", resourceType=" + this.resourceType + ", resourceName=" + this.resourceName + ", defaultYamlPath=" + this.defaultYamlPath + ", yamlStr=" + this.yamlStr + ", connectionMapList=" + String.valueOf(this.connectionMapList) + ", remark=" + this.remark + ", propList=" + String.valueOf(this.propList) + ", defaultExtendConfigPath=" + Arrays.deepToString(this.defaultExtendConfigPath) + ")";
        }
    }
}

