/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.ozhera.trace.etl.api.service.IEnterManager;
import org.apache.ozhera.trace.etl.api.service.IMetricsParseService;
import org.apache.ozhera.trace.etl.api.service.MQExtension;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.util.ThriftUtil;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mq.type"}, havingValue="kafka")
public class KafkaConsumerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerService.class);
    @Value(value="${mq.consumer.group}")
    private String consumerGroup;
    @Value(value="${mq.producer.group}")
    private String producerGroup;
    @NacosValue(value="${mq.nameseraddr}")
    private String nameSerAddr;
    @Value(value="${mq.server.topic}")
    private String topicName;
    @Value(value="${mq.es.topic}")
    private String esTopicName;
    @Resource
    private IEnterManager enterManager;
    @Resource
    private IMetricsParseService metricsExporterService;
    @Autowired
    private MQExtension mq;

    @PostConstruct
    public void takeMessage() throws MQClientException {
        MqConfig config = new MqConfig();
        config.setNameSerAddr(this.nameSerAddr);
        config.setProducerGroup(this.producerGroup);
        config.setProducerTopicName(this.esTopicName);
        config.setConsumerGroup(this.consumerGroup);
        config.setConsumerTopicName(this.topicName);
        config.setConsumerMethod(records -> {
            this.enterManager.enter();
            this.enterManager.getProcessNum().incrementAndGet();
            try {
                ArrayList<ProducerRecord> producerRecordList = new ArrayList<ProducerRecord>();
                for (ConsumerRecord message : records) {
                    String traceId = "";
                    try {
                        TSpanData tSpanData = new TSpanData();
                        new TDeserializer(ThriftUtil.PROTOCOL_FACTORY).deserialize((TBase)tSpanData, ((String)message.value()).getBytes(StandardCharsets.ISO_8859_1));
                        traceId = tSpanData.getTraceId();
                        this.metricsExporterService.parse(tSpanData);
                    }
                    catch (Throwable t) {
                        log.error("consumer message error", t);
                    }
                    producerRecordList.add(new ProducerRecord(this.esTopicName, (Object)traceId, (Object)((String)message.value())));
                }
                if (producerRecordList.size() > 0) {
                    this.mq.send(producerRecordList);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                this.enterManager.getProcessNum().decrementAndGet();
            }
        });
        this.mq.initMq(config);
    }
}

