/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.ozhera.monitor.dao.mapper.AppGrafanaMappingMapper;
import org.apache.ozhera.monitor.dao.model.AppGrafanaMapping;
import org.apache.ozhera.monitor.dao.model.AppGrafanaMappingExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppGrafanaMappingDao {
    private static final Logger log = LoggerFactory.getLogger(AppGrafanaMappingDao.class);
    @Autowired
    private AppGrafanaMappingMapper appGrafanaMappingMapper;

    public Long getDataTotal() {
        return this.appGrafanaMappingMapper.countByExample(null);
    }

    public List<AppGrafanaMapping> getData(Integer offset, Integer pageSize) {
        AppGrafanaMappingExample example = new AppGrafanaMappingExample();
        example.setOffset(offset);
        example.setLimit(pageSize);
        example.setOrderByClause("id desc");
        return this.appGrafanaMappingMapper.selectByExample(example);
    }

    public int generateGrafanaMapping(AppGrafanaMapping appGrafanaMapping) {
        if (null == appGrafanaMapping) {
            log.error("[AppGrafanaMappingDao.generateGrafanaMapping] null appGrafanaMapping");
            return 0;
        }
        appGrafanaMapping.setCreateTime(new Date());
        appGrafanaMapping.setUpdateTime(new Date());
        try {
            int affected = this.appGrafanaMappingMapper.insert(appGrafanaMapping);
            if (affected < 1) {
                log.warn("[AppGrafanaMappingDao.generateGrafanaMapping] failed to insert AppGrafanaMapping: {}", (Object)appGrafanaMapping.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppGrafanaMappingDao.generateGrafanaMapping] failed to insert AppGrafanaMapping: {}, err: {}", (Object)appGrafanaMapping.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public AppGrafanaMapping getByAppName(String appName) {
        AppGrafanaMappingExample example = new AppGrafanaMappingExample();
        AppGrafanaMappingExample.Criteria ca = example.createCriteria();
        ca.andAppNameEqualTo(appName);
        List<AppGrafanaMapping> appGrafanaMappings = this.appGrafanaMappingMapper.selectByExample(example);
        if (appGrafanaMappings.size() > 0) {
            return appGrafanaMappings.get(0);
        }
        return null;
    }

    public int updateByPrimaryKey(AppGrafanaMapping appGrafanaMapping) {
        try {
            appGrafanaMapping.setUpdateTime(new Date());
            int i = this.appGrafanaMappingMapper.updateByPrimaryKey(appGrafanaMapping);
            if (i < 0) {
                log.warn("[AppGrafanaMappingDao.updateByPrimaryKey] failed to update AppGrafanaMapping: {}", (Object)appGrafanaMapping.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppGrafanaMappingDao.updateByPrimaryKey] failed to update AppGrafanaMapping: {}, err: {}", (Object)appGrafanaMapping.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

