/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.ReqErrorMetrics;
import org.apache.ozhera.monitor.bo.ReqSlowMetrics;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.ComputeTimerServiceExtension;
import org.apache.ozhera.monitor.service.model.AppMonitorRequest;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.Metric;
import org.apache.ozhera.monitor.service.model.prometheus.MetricKind;
import org.apache.ozhera.monitor.service.model.redis.AppAlarmData;
import org.apache.ozhera.monitor.service.prometheus.MetricSuffix;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class ComputeTimerServiceExtensionImpl
implements ComputeTimerServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(ComputeTimerServiceExtensionImpl.class);
    @Autowired
    private PrometheusService prometheusService;

    @Override
    public void computByMetricType(AppMonitorRequest param, String appName, MetricKind metricKind, AppAlarmData.AppAlarmDataBuilder dataBuilder, Long startTime, Long endTime, String timeDuration, Long step) {
        try {
            MetricKind.MetricType curMetricType = null;
            if (param != null) {
                curMetricType = MetricKind.getMetricTypeByCode(param.getMetricType());
            }
            switch (metricKind) {
                case http: {
                    Result<PageData> httpExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.httpError.getCode(), this.getLable(MetricKind.MetricType.http_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.httpExceptionNum(this.countRecordMetric(httpExceptions));
                    Result<PageData> httpClientExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.httpClientError.getCode(), this.getLable(MetricKind.MetricType.http_client_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.httpClientExceptionNum(this.countRecordMetric(httpClientExceptions));
                    Result<PageData> httpSlowQuery = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.httpSlowQuery.getCode(), this.getLable(MetricKind.MetricType.http_slow, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.httpSlowNum(this.countRecordMetric(httpSlowQuery));
                    Result<PageData> httpClientSlowQuerys = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.httpClientSlowQuery.getCode(), this.getLable(MetricKind.MetricType.http_client_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.httpClientSlowNum(this.countRecordMetric(httpClientSlowQuerys));
                    break;
                }
                case dubbo: {
                    Result<PageData> dubboExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.dubboConsumerError.getCode(), this.getLable(MetricKind.MetricType.dubbo_consumer_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.dubboExceptionNum(this.countRecordMetric(dubboExceptions));
                    Result<PageData> dubboPExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.dubboProvider.getCode(), this.getLable(MetricKind.MetricType.dubbo_provider_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.dubboPExceptionNum(this.countRecordMetric(dubboPExceptions));
                    Result<PageData> dubboConsumerSlowQuerys = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.dubboConsumerSlowQuery.getCode(), this.getLable(MetricKind.MetricType.dubbo_consumer_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.dubboCSlowQueryNum(this.countRecordMetric(dubboConsumerSlowQuerys));
                    log.info("projectName:{},dubboConsumerSlowQuerys:{}", (Object)appName, dubboConsumerSlowQuerys);
                    Result<PageData> dubboProviderSlowQuerys = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.dubboProviderSlowQuery.getCode(), this.getLable(MetricKind.MetricType.dubbo_provider_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.dubboProviderSlowQueryNum(this.countRecordMetric(dubboProviderSlowQuerys));
                    log.info("projectName:{},dubboProviderSlowQuerys:{}", (Object)appName, dubboProviderSlowQuerys);
                    break;
                }
                case grpc: {
                    Result<PageData> grpcServerExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.grpcServerError.getCode(), this.getLable(MetricKind.MetricType.grpc_server_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.grpcServerErrorNum(this.countRecordMetric(grpcServerExceptions));
                    Result<PageData> grpcClientExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.grpcClientError.getCode(), this.getLable(MetricKind.MetricType.grpc_client_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.grpcClientErrorNum(this.countRecordMetric(grpcClientExceptions));
                    Result<PageData> grpcClientSlowQuery = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.grpcClientSlowQuery.getCode(), this.getLable(MetricKind.MetricType.grpc_client_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.grpcClientSlowQueryNum(this.countRecordMetric(grpcClientSlowQuery));
                    Result<PageData> grpcServerSlowQuery = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.grpcServerSlowQuery.getCode(), this.getLable(MetricKind.MetricType.grpc_server_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.grpcServerSlowQueryNum(this.countRecordMetric(grpcServerSlowQuery));
                    break;
                }
                case db: {
                    Result<PageData> sqlExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.dbError.getCode(), this.getLable(MetricKind.MetricType.db_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.sqlExceptionNum(this.countRecordMetric(sqlExceptions));
                    Result<PageData> sqlSlowQuerys = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.dbSlowQuery.getCode(), this.getLable(MetricKind.MetricType.db_slow_query, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.sqlSlowQueryNum(this.countRecordMetric(sqlSlowQuerys));
                    break;
                }
                case redis: {
                    Result<PageData> redisExceptions = this.prometheusService.queryRangeSumOverTime(ReqErrorMetrics.redisError.getCode(), this.getLable(MetricKind.MetricType.redis_exception, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.redisExceptionNum(this.countRecordMetric(redisExceptions));
                    Result<PageData> redisSlowQuerys = this.prometheusService.queryRangeSumOverTime(ReqSlowMetrics.redisSlow.getCode(), this.getLable(MetricKind.MetricType.redis_slow, curMetricType, param), appName, MetricSuffix._total.name(), startTime, endTime, step, timeDuration, null);
                    dataBuilder.redisSlowNum(this.countRecordMetric(redisSlowQuerys));
                    break;
                }
                default: {
                    log.error("invalid metric kind assign! metricType:{}", (Object)metricKind);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("ComputeTimerServiceV2.getAppAlarmData error! appName={}", (Object)appName, (Object)e);
        }
    }

    private Integer countRecordMetric(Result<PageData> result) {
        if (ErrorCode.success.getCode() != result.getCode()) {
            log.error("ComputeTimerService.countRecordMetric error! result : {}", (Object)result.toString());
            return 0;
        }
        PageData data = (PageData)result.getData();
        List metrics = (List)data.getList();
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            return 0;
        }
        Integer ret = 0;
        for (Metric metric : metrics) {
            Integer n = ret;
            ret = ret + 1;
        }
        log.info("ComputeTimerService.countRecordMetric ret : {}", (Object)ret);
        return ret;
    }

    private Map<String, String> getLable(MetricKind.MetricType metricTypeTarget, MetricKind.MetricType metricTypeParam, AppMonitorRequest param) {
        if (metricTypeTarget == null || metricTypeParam == null || param == null) {
            return null;
        }
        return metricTypeTarget == metricTypeParam ? this.getLabelByMetricType(param.getMetricType(), param.getMethodName()) : null;
    }

    private Map<String, String> getLabelByMetricType(String metricType, String methodName) {
        if (StringUtils.isBlank((CharSequence)metricType)) {
            return null;
        }
        MetricKind metricKind = MetricKind.getByMetricType(metricType);
        return this.getLabelByMetricKind(metricKind, methodName);
    }

    private Map<String, String> getLabelByMetricKind(MetricKind metricKind, String methodName) {
        if (metricKind == null) {
            return null;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(metricKind.getLebelName(), methodName);
        return labels;
    }
}

