/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.ComputeTimerService;
import org.apache.ozhera.monitor.service.api.ComputeTimerServiceExtension;
import org.apache.ozhera.monitor.service.helper.AlertHelper;
import org.apache.ozhera.monitor.service.model.AppMonitorRequest;
import org.apache.ozhera.monitor.service.model.ProjectInfo;
import org.apache.ozhera.monitor.service.model.prometheus.MetricKind;
import org.apache.ozhera.monitor.service.model.redis.AppAlarmData;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.apache.ozhera.monitor.utils.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ComputeTimerServiceImpl
implements ComputeTimerService {
    private static final Logger log = LoggerFactory.getLogger(ComputeTimerServiceImpl.class);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 50, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(100), r -> new Thread(r, "compute-execute-thread-v2"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ThreadPoolExecutor metricExecutor = new ThreadPoolExecutor(50, 100, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), r -> new Thread(r, "compute-metric-thread-v2"), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    PrometheusService prometheusService;
    @Autowired
    private AlertHelper alertHelper;
    @Autowired
    private ComputeTimerServiceExtension computeTimerServiceExtension;

    @Override
    @PreDestroy
    public void destory() {
        this.executor.shutdownNow();
        this.metricExecutor.shutdownNow();
    }

    @Override
    public Result<List<AppAlarmData>> getProjectStatistics(final AppMonitorRequest param) {
        final Long endTime = CommonUtil.toSeconds((Long)System.currentTimeMillis());
        final Long startTime = endTime - param.getDuration();
        final String timeDuration = param.getDuration() + "s";
        final Long step = param.getDuration();
        int projectSize = param.getProjectList().size() > 50 ? 50 : param.getProjectList().size();
        ArrayList<1> callList = new ArrayList<1>();
        for (int idx = 0; idx < projectSize; ++idx) {
            final ProjectInfo project = param.getProjectList().get(idx);
            if (project.getId() == null || StringUtils.isBlank((CharSequence)project.getName()) || project.getIamTreeId() == null) continue;
            callList.add(new Callable(){

                public AppAlarmData call() throws Exception {
                    return ComputeTimerServiceImpl.this.getAppAlarmData(project, startTime, endTime, timeDuration, step, param);
                }
            });
        }
        ArrayList<AppAlarmData> dataList = new ArrayList<AppAlarmData>();
        try {
            List futures = this.executor.invokeAll(callList, 30L, TimeUnit.SECONDS);
            if (!CollectionUtils.isEmpty(futures)) {
                AppAlarmData data = null;
                for (Future future : futures) {
                    data = (AppAlarmData)future.get();
                    if (data == null) continue;
                    dataList.add(data);
                }
            }
        }
        catch (Exception e) {
            log.info("ComputeTimerServiceV2.executor.invokeAll\u5f02\u5e38  param={}, ", (Object)param, (Object)e);
        }
        return Result.success(dataList);
    }

    @Override
    public AppAlarmData getAppAlarmData(ProjectInfo project, final Long startTime, final Long endTime, final String timeDuration, final Long step, final AppMonitorRequest param) {
        final String appName = project.getId() + "_" + project.getName().replaceAll("-", "_");
        AppAlarmData data = null;
        final AppAlarmData.AppAlarmDataBuilder dataBuilder = AppAlarmData.builder();
        dataBuilder.id(project.getId()).name(project.getName()).iamTreeId(project.getIamTreeId());
        dataBuilder.startTime(startTime).endTime(endTime);
        ArrayList kinds = Lists.newArrayList((Object[])new MetricKind[]{MetricKind.http, MetricKind.dubbo, MetricKind.grpc, MetricKind.apus, MetricKind.thrift, MetricKind.db, MetricKind.redis});
        List callList = kinds.stream().map(kind -> new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ComputeTimerServiceImpl.this.computByMetricType(param, appName, kind, dataBuilder, startTime, endTime, timeDuration, step);
                return null;
            }
        }).collect(Collectors.toList());
        try {
            List futureList = this.metricExecutor.invokeAll(callList);
            if (param == null) {
                dataBuilder.alertTotal(this.alertHelper.queryAlertEventNum(project.getId().intValue(), project.getIamTreeId().intValue(), startTime, endTime));
            }
            futureList.stream().forEach(f -> {
                try {
                    f.get();
                }
                catch (Throwable e) {
                    log.warn("metric\u7edf\u8ba1\u67e5\u8be2\u5f02\u6b65get\u7ed3\u679c\u5f02\u5e38", (Object)project.getName(), (Object)e);
                }
            });
        }
        catch (Throwable e) {
            log.error("metric\u7edf\u8ba1\u5f02\u6b65\u67e5\u8be2\u5f02\u5e38 projectName={}", (Object)project.getName(), (Object)e);
        }
        dataBuilder.logExceptionNum(0);
        data = dataBuilder.build();
        this.calExceptionTotal(data);
        this.calSlowQueryTotal(data);
        log.info("ComputeTimerServiceV2.getAppAlarmData new-result appName={}, data={}", (Object)appName, (Object)data);
        return data;
    }

    private void computByMetricType(AppMonitorRequest param, String appName, MetricKind metricKind, AppAlarmData.AppAlarmDataBuilder dataBuilder, Long startTime, Long endTime, String timeDuration, Long step) {
        this.computeTimerServiceExtension.computByMetricType(param, appName, metricKind, dataBuilder, startTime, endTime, timeDuration, step);
    }

    @Override
    public AppAlarmData countAppMetricData(AppMonitorRequest param) {
        ProjectInfo project = param.getProjectList().get(0);
        Long startTime = param.getStartTimeCurrent();
        Long endTime = param.getEndTimeCurrent();
        Long step = endTime - startTime;
        return this.getAppAlarmData(project, startTime, endTime, step + "s", step, param);
    }

    private void calExceptionTotal(AppAlarmData data) {
        Integer exceptionTotal = 0;
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getHttpExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getHttpClientExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getDubboExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getDubboPExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getSqlExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getOracleExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getRedisExceptionNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getGrpcServerErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getGrpcClientErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getApusServerErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getApusClientErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getThriftServerErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getThriftClientErrorNum()).orElse(0);
        exceptionTotal = exceptionTotal + Optional.ofNullable(data.getEsExceptionNum()).orElse(0);
        data.setExceptionTotal(exceptionTotal);
    }

    private void calSlowQueryTotal(AppAlarmData data) {
        Integer slowQueryTotal = 0;
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getHttpSlowNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getHttpClientSlowNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getDubboCSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getDubboProviderSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getSqlSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getOracleSlowNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getRedisSlowNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getGrpcClientSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getGrpcServerSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getApusClientSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getApusServerSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getThriftClientSlowQueryNum()).orElse(0);
        slowQueryTotal = slowQueryTotal + Optional.ofNullable(data.getEsSlowNum()).orElse(0);
        data.setSlowTotal(slowQueryTotal);
    }
}

