/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.monitor.dao.HeraAppRoleDao;
import org.apache.ozhera.monitor.dao.model.HeraAppRole;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.ResourceUsageService;
import org.apache.ozhera.monitor.service.alertmanager.AlarmExprService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.ResourceUsageMessage;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceUsageServiceImpl
implements ResourceUsageService {
    @Autowired
    AlarmExprService alarmExprService;
    @Autowired
    PrometheusService prometheusService;
    @Autowired
    HeraAppRoleDao heraAppRoleDao;
    @NacosValue(value="${resource.use.rate.alarm.config:1}", autoRefreshed=true)
    private String resourceAlarm;

    @Override
    public List<ResourceUsageMessage> getCpuUsageData() {
        List list;
        String mimonitor = this.alarmExprService.getContainerCpuResourceAlarmExpr(null, "mimonitor", "<", Integer.valueOf(this.resourceAlarm).intValue(), false, null);
        Result<PageData> pageDataResult = this.prometheusService.queryByMetric(mimonitor);
        PageData data = (PageData)pageDataResult.getData();
        List<ResourceUsageMessage> listMsg = new ArrayList<ResourceUsageMessage>();
        if (data != null && CollectionUtils.isNotEmpty((Collection)(list = (List)data.getList()))) {
            listMsg = list.stream().map(t -> {
                List<HeraAppRole> query = this.heraAppRoleDao.queryByPlatTypes(t.getContainer_label_PROJECT_ID(), Lists.newArrayList((Object[])new Integer[]{0, 2}), 0, 5);
                ArrayList members = CollectionUtils.isEmpty(query) ? Lists.newArrayList() : query.stream().map(r -> r.getUser()).collect(Collectors.toList());
                return new ResourceUsageMessage(t.getIp(), t.getContainer_label_PROJECT_ID(), t.getName().substring(0, t.getName().lastIndexOf("-")), String.valueOf(t.getValue()), null, members, this.resourceAlarm + "%");
            }).collect(Collectors.toList());
        }
        return listMsg;
    }

    @Override
    public List<ResourceUsageMessage> getMemUsageData() {
        List list;
        String mimonitor = this.alarmExprService.getContainerMemResourceAlarmExpr(null, "mimonitor", "<", Integer.valueOf(this.resourceAlarm).intValue(), false, null);
        Result<PageData> pageDataResult = this.prometheusService.queryByMetric(mimonitor);
        PageData data = (PageData)pageDataResult.getData();
        List<ResourceUsageMessage> listMsg = new ArrayList<ResourceUsageMessage>();
        if (data != null && CollectionUtils.isNotEmpty((Collection)(list = (List)data.getList()))) {
            listMsg = list.stream().map(t -> {
                List<HeraAppRole> query = this.heraAppRoleDao.queryByPlatTypes(t.getContainer_label_PROJECT_ID(), Lists.newArrayList((Object[])new Integer[]{0, 2}), 0, 5);
                ArrayList members = CollectionUtils.isEmpty(query) ? Lists.newArrayList() : query.stream().map(r -> r.getUser()).collect(Collectors.toList());
                return new ResourceUsageMessage(t.getIp(), t.getContainer_label_PROJECT_ID(), t.getName().substring(0, t.getName().lastIndexOf("-")), String.valueOf(t.getValue()), null, members, this.resourceAlarm + "%");
            }).collect(Collectors.toList());
        }
        return listMsg;
    }
}

