/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.prometheus;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmRuleMetricType;
import org.apache.ozhera.monitor.bo.ResourceUsageMetrics;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.pojo.AlarmPresetMetricsPOJO;
import org.apache.ozhera.monitor.pojo.ReqErrorMetricsPOJO;
import org.apache.ozhera.monitor.pojo.ReqSlowMetricsPOJO;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.alertmanager.AlarmExprService;
import org.apache.ozhera.monitor.service.alertmanager.AlertServiceAdapt;
import org.apache.ozhera.monitor.service.api.AlarmPresetMetricsService;
import org.apache.ozhera.monitor.service.api.AlarmServiceExtension;
import org.apache.ozhera.monitor.service.api.ReqErrorMetricsService;
import org.apache.ozhera.monitor.service.api.ReqSlowMetricsService;
import org.apache.ozhera.monitor.service.api.TeslaService;
import org.apache.ozhera.monitor.service.helper.AlertUrlHelper;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleData;
import org.apache.ozhera.monitor.service.model.prometheus.Metric;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlarmService {
    private static final Logger log = LoggerFactory.getLogger(AlarmService.class);
    @NacosValue(value="${prometheus.alarm.env:staging}", autoRefreshed=true)
    private String prometheusAlarmEnv;
    @Value(value="${server.type}")
    private String serverType;
    @NacosValue(value="${rule.evaluation.interval:30}", autoRefreshed=true)
    private Integer evaluationInterval;
    @NacosValue(value="${rule.evaluation.duration:30}", autoRefreshed=true)
    private Integer evaluationDuration;
    @NacosValue(value="${rule.evaluation.unit:s}", autoRefreshed=true)
    private String evaluationUnit;
    @Autowired
    PrometheusService prometheusService;
    @Autowired
    AlertServiceAdapt alertServiceAdapt;
    @Autowired
    private AlertUrlHelper alertUrlHelper;
    @Autowired
    private AlarmPresetMetricsService alarmPresetMetricsService;
    @Autowired
    private ReqErrorMetricsService reqErrorMetricsService;
    @Autowired
    private ReqSlowMetricsService reqSlowMetricsService;
    @Autowired
    private AlarmServiceExtension alarmServiceExtension;
    @Autowired
    private AlarmExprService alarmExprService;
    @Autowired
    TeslaService teslaService;
    @Value(value="${server.type}")
    private String env;

    public String getExpr(AppAlarmRule rule, String scrapeIntervel, AlarmRuleData ruleData, AppMonitor app) {
        app.setProjectName(app.getProjectName().replaceAll("-", "_"));
        return this.alarmExprService.getExpr(rule, scrapeIntervel, ruleData, app);
    }

    public List<String> getInstanceIpList(Integer projectId, String projectName) {
        List<Metric> metrics = this.listInstanceMetric(projectId, projectName);
        if (CollectionUtils.isEmpty(metrics)) {
            log.error("getInstanceIps no data found! projectId :{},projectName:{}", (Object)projectId, (Object)projectName);
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Metric metric : metrics) {
            result.add(metric.getIp());
        }
        return result;
    }

    public Map getEnvIpMapping(Integer projectId, String projectName) {
        return this.alarmExprService.getEnvIpMapping(projectId, projectName);
    }

    private List<Metric> listInstanceMetric(Integer projectId, String projectName) {
        projectName = projectName.replaceAll("-", "_");
        StringBuilder builder = new StringBuilder();
        builder.append("process_uptime_seconds{application=\"").append(projectId).append("_").append(projectName).append("\"").append("}");
        Result<PageData> pageDataResult = this.prometheusService.queryByMetric(builder.toString());
        if (pageDataResult.getCode() != ErrorCode.success.getCode() || pageDataResult.getData() == null) {
            log.error("queryByMetric error! projectId :{},projectName:{}", (Object)projectId, (Object)projectName);
            return null;
        }
        List list = (List)((PageData)pageDataResult.getData()).getList();
        log.info("listInstanceMetric param projectName:{},result:{}", (Object)projectName, (Object)list.size());
        return list;
    }

    public List<String> getHttpClientServerDomain(Integer projectId, String projectName) {
        List<Metric> metrics = this.listHttpMetric(projectId, projectName);
        if (CollectionUtils.isEmpty(metrics)) {
            log.error("getHttpClientServerDomain no data found! projectId :{},projectName:{}", (Object)projectId, (Object)projectName);
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Metric metric : metrics) {
            result.add(metric.getServiceName());
        }
        return result;
    }

    private List<Metric> listHttpMetric(Integer projectId, String projectName) {
        projectName = projectName.replaceAll("-", "_");
        StringBuilder builder = new StringBuilder();
        builder.append(this.serverType);
        builder.append("_jaeger_aopClientTotalMethodCount_total{application=\"").append(projectId).append("_").append(projectName).append("\"").append(",serviceName!=''}");
        Result<PageData> pageDataResult = this.prometheusService.queryByMetric(builder.toString());
        if (pageDataResult.getCode() != ErrorCode.success.getCode() || pageDataResult.getData() == null) {
            log.error("queryByMetric error! projectId :{},projectName:{}", (Object)projectId, (Object)projectName);
            return null;
        }
        List list = (List)((PageData)pageDataResult.getData()).getList();
        log.info("listHttpMetric param projectName:{},result:{}", (Object)projectName, (Object)list.size());
        return list;
    }

    private List<Metric> listContainerNameMetric(Integer projectId, String projectName) {
        projectName = projectName.replaceAll("-", "_");
        StringBuilder builder = new StringBuilder();
        builder.append("jvm_classes_loaded_classes{ containerName != '',application=\"").append(projectId).append("_").append(projectName).append("\"").append("}");
        Result<PageData> pageDataResult = this.prometheusService.queryByMetric(builder.toString());
        if (pageDataResult.getCode() != ErrorCode.success.getCode() || pageDataResult.getData() == null) {
            log.error("listContainerNameMetric error! projectId :{},projectName:{}", (Object)projectId, (Object)projectName);
            return null;
        }
        List list = (List)((PageData)pageDataResult.getData()).getList();
        log.info("listContainerNameMetric param projectName:{},result:{}", (Object)projectName, (Object)list.size());
        return list;
    }

    public List<String> listContainerName(Integer projectId, String projectName) {
        List<Metric> metrics = this.listContainerNameMetric(projectId, projectName);
        if (CollectionUtils.isEmpty(metrics)) {
            return Lists.newArrayList();
        }
        return metrics.stream().map(t -> t.getContainerName()).distinct().collect(Collectors.toList());
    }

    public Result addRule(AppMonitor app, AppAlarmRule rule, String user, AlarmRuleData ruleData) {
        JsonArray array;
        ResourceUsageMetrics errorMetricsByMetrics;
        ReqSlowMetricsPOJO slowMetrics;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("alert", rule.getAlert());
        jsonObject.addProperty("cname", rule.getCname());
        jsonObject.addProperty("for", rule.getForTime());
        jsonObject.addProperty("forTime", rule.getForTime());
        StringBuilder title = new StringBuilder().append(app.getProjectName());
        AlarmPresetMetricsPOJO metrics = this.alarmPresetMetricsService.getByCode(rule.getAlert());
        if (metrics != null) {
            title.append("&").append(metrics.getMessage());
        } else {
            this.teslaService.checkTeslaMetrics(title, rule.getAlert());
        }
        JsonObject jsonSummary = new JsonObject();
        jsonSummary.addProperty("title", title.toString());
        if (StringUtils.isNotBlank((CharSequence)rule.getRemark())) {
            jsonSummary.addProperty("summary", rule.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)ruleData.getAlarmCallbackUrl())) {
            jsonSummary.addProperty("callback_url", ruleData.getAlarmCallbackUrl());
        }
        jsonObject.add("annotations", (JsonElement)jsonSummary);
        Result<String> groupResult = this.alarmServiceExtension.getGroup(rule.getIamId(), user);
        if (!groupResult.isSuccess()) {
            return groupResult;
        }
        jsonObject.addProperty("group", (String)groupResult.getData());
        jsonObject.addProperty("priority", rule.getPriority());
        JsonArray envArray = new JsonArray();
        envArray.add(rule.getEnv());
        jsonObject.add("env", (JsonElement)envArray);
        JsonObject labels = new JsonObject();
        labels.addProperty("exceptViewLables", "detailRedirectUrl.paramType");
        if (StringUtils.isNotBlank((CharSequence)ruleData.getAlarmDetailUrl())) {
            labels.addProperty("detailRedirectUrl", ruleData.getAlarmDetailUrl());
            labels.addProperty("paramType", "customerPromql");
        }
        this.alertUrlHelper.buildDetailRedirectUrl(user, app, rule.getAlert(), jsonSummary, labels);
        labels.addProperty("send_interval", rule.getSendInterval());
        labels.addProperty("app_iam_id", String.valueOf(rule.getIamId()));
        labels.addProperty("project_id", String.valueOf(rule.getProjectId()));
        labels.addProperty("project_name", app.getProjectName());
        if (StringUtils.isNotBlank((CharSequence)rule.getAlert())) {
            labels.addProperty("alert_key", rule.getAlert());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getOp())) {
            labels.addProperty("alert_op", rule.getOp());
        }
        if (rule.getMetricType() == AlarmRuleMetricType.customer_promql.getCode()) {
            String ruleExpr = ruleData.getExpr();
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(ruleExpr.lastIndexOf(">="));
            set.add(ruleExpr.lastIndexOf("<="));
            set.add(ruleExpr.lastIndexOf("!="));
            set.add(ruleExpr.lastIndexOf(">"));
            set.add(ruleExpr.lastIndexOf("<"));
            set.add(ruleExpr.lastIndexOf("="));
            List indexSet = set.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            int a = CollectionUtils.isEmpty(indexSet) ? -1 : (Integer)indexSet.get(0);
            log.info("add customer_promql ruleExpr :{},a:{}", (Object)ruleExpr, (Object)a);
            String value = "0.0";
            if (a > 0) {
                try {
                    value = ruleExpr.substring(a + 1).trim();
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage() + "ruleExpr : {} ; a : {}", new Object[]{ruleExpr, a, e});
                }
            }
            labels.addProperty("alert_value", value);
        } else if (rule.getValue() != null) {
            labels.addProperty("alert_value", rule.getValue().toString());
        }
        if (metrics != null) {
            labels.addProperty("calert", metrics.getMessage());
            labels.addProperty("group_key", metrics.getGroupKey().getCode());
        } else {
            labels.addProperty("calert", rule.getAlert());
        }
        ReqErrorMetricsPOJO errMetrics = this.reqErrorMetricsService.getErrorMetricsByMetrics(rule.getAlert());
        if (errMetrics != null) {
            labels.addProperty("metrics_flag", "1");
            labels.addProperty("metrics", errMetrics.getCode());
        }
        if ((slowMetrics = this.reqSlowMetricsService.getSlowMetricsByMetric(rule.getAlert())) != null) {
            labels.addProperty("metrics_flag", "2");
            labels.addProperty("metrics", slowMetrics.getCode());
        }
        if ((errorMetricsByMetrics = ResourceUsageMetrics.getErrorMetricsByMetrics(rule.getAlert())) != null) {
            labels.addProperty("metrics_flag", errorMetricsByMetrics.getMetricsFlag());
            labels.addProperty("metrics", errorMetricsByMetrics.getCode());
        }
        jsonObject.add("labels", (JsonElement)labels);
        if (rule.getMetricType().equals(AlarmRuleMetricType.preset.getCode())) {
            String evaluationIntervalS = this.evaluationDuration + this.evaluationUnit;
            String expr = this.getExpr(rule, evaluationIntervalS, ruleData, app);
            log.info("presetMetric expr===========" + expr);
            if (StringUtils.isBlank((CharSequence)expr)) {
                log.error("getExpr error!rule:{},projectName:{}", (Object)rule.toString(), (Object)app.getProjectName());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            jsonObject.addProperty("expr", expr);
            rule.setExpr(expr);
        } else if (rule.getMetricType().equals(AlarmRuleMetricType.customer_promql.getCode())) {
            log.info("customize expr:projectId:{},projectName:{},expr:{}", new Object[]{app.getProjectId(), app.getProjectName(), ruleData.getExpr()});
            jsonObject.addProperty("expr", ruleData.getExpr());
        }
        String alertTeamJson = rule.getAlertTeam();
        List<String> alertMembers = ruleData.getAlertMembers();
        if (StringUtils.isBlank((CharSequence)alertTeamJson) && CollectionUtils.isEmpty(alertMembers)) {
            log.error("AlarmService.addRule error! invalid alarmTeam and alertMembers param!");
            return Result.fail((ErrorCode)ErrorCode.ALERT_TEAM_AND_ALERT_MEMBERS_BOTH_EMPTY);
        }
        if (StringUtils.isNotBlank((CharSequence)alertTeamJson)) {
            array = (JsonArray)new Gson().fromJson(alertTeamJson, JsonArray.class);
            jsonObject.add("alert_team", (JsonElement)array);
        }
        if (!CollectionUtils.isEmpty(alertMembers)) {
            array = (JsonArray)new Gson().fromJson(JSON.toJSONString(alertMembers), JsonArray.class);
            jsonObject.add("alert_member", (JsonElement)array);
        }
        if (!CollectionUtils.isEmpty(ruleData.getAtMembers())) {
            array = (JsonArray)new Gson().fromJson(JSON.toJSONString(ruleData.getAtMembers()), JsonArray.class);
            jsonObject.add("alert_at_people", (JsonElement)array);
        }
        return this.alertServiceAdapt.addRule(jsonObject, String.valueOf(rule.getIamId()), user);
    }

    public Result editRule(AppAlarmRule rule, AlarmRuleData ruleData, AppMonitor app, String user) {
        ResourceUsageMetrics errorMetricsByMetrics;
        ReqSlowMetricsPOJO slowMetrics;
        JsonObject jsonObject = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)rule.getCname())) {
            jsonObject.addProperty("cname", rule.getCname());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getForTime())) {
            jsonObject.addProperty("for", rule.getForTime());
            jsonObject.addProperty("forTime", rule.getForTime());
        }
        StringBuilder title = new StringBuilder().append(app.getProjectName());
        AlarmPresetMetricsPOJO metrics = this.alarmPresetMetricsService.getByCode(rule.getAlert());
        if (metrics != null) {
            title.append("&").append(metrics.getMessage());
        } else {
            this.teslaService.checkTeslaMetrics(title, rule.getAlert());
        }
        JsonObject jsonSummary = new JsonObject();
        jsonSummary.addProperty("title", title.toString());
        if (StringUtils.isNotBlank((CharSequence)rule.getRemark())) {
            jsonSummary.addProperty("summary", rule.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)ruleData.getAlarmCallbackUrl())) {
            jsonSummary.addProperty("callback_url", ruleData.getAlarmCallbackUrl());
        }
        jsonObject.add("annotations", (JsonElement)jsonSummary);
        if (StringUtils.isNotBlank((CharSequence)rule.getPriority())) {
            jsonObject.addProperty("priority", rule.getPriority());
        }
        JsonObject labels = new JsonObject();
        labels.addProperty("exceptViewLables", "detailRedirectUrl.paramType");
        if (StringUtils.isNotBlank((CharSequence)ruleData.getAlarmDetailUrl())) {
            labels.addProperty("detailRedirectUrl", ruleData.getAlarmDetailUrl());
            labels.addProperty("paramType", "customerPromql");
        }
        this.alertUrlHelper.buildDetailRedirectUrl(user, app, rule.getAlert(), jsonSummary, labels);
        labels.addProperty("send_interval", rule.getSendInterval());
        labels.addProperty("app_iam_id", String.valueOf(rule.getIamId()));
        labels.addProperty("project_id", String.valueOf(rule.getProjectId()));
        labels.addProperty("project_name", app.getProjectName());
        if (StringUtils.isNotBlank((CharSequence)rule.getAlert())) {
            labels.addProperty("alert_key", rule.getAlert());
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getOp())) {
            labels.addProperty("alert_op", rule.getOp());
        }
        if (rule.getMetricType() == AlarmRuleMetricType.customer_promql.getCode()) {
            String ruleExpr = ruleData.getExpr();
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(ruleExpr.lastIndexOf(">="));
            set.add(ruleExpr.lastIndexOf("<="));
            set.add(ruleExpr.lastIndexOf("!="));
            set.add(ruleExpr.lastIndexOf(">"));
            set.add(ruleExpr.lastIndexOf("<"));
            set.add(ruleExpr.lastIndexOf("="));
            List indexSet = set.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            int a = CollectionUtils.isEmpty(indexSet) ? -1 : (Integer)indexSet.get(0);
            log.info("add customer_promql ruleExpr :{},a:{}", (Object)ruleExpr, (Object)a);
            String value = "0.0";
            if (a > 0) {
                try {
                    value = ruleExpr.substring(a + 1).trim();
                }
                catch (NumberFormatException e) {
                    log.error(e.getMessage() + "ruleExpr : {} ; a : {}", new Object[]{ruleExpr, a, e});
                }
            }
            labels.addProperty("alert_value", value);
        } else if (rule.getValue() != null) {
            labels.addProperty("alert_value", rule.getValue().toString());
        }
        if (metrics != null) {
            labels.addProperty("calert", metrics.getMessage());
            labels.addProperty("group_key", metrics.getGroupKey().getCode());
        } else {
            labels.addProperty("calert", rule.getAlert());
        }
        ReqErrorMetricsPOJO errMetrics = this.reqErrorMetricsService.getErrorMetricsByMetrics(rule.getAlert());
        if (errMetrics != null) {
            labels.addProperty("metrics_flag", "1");
            labels.addProperty("metrics", errMetrics.getCode());
        }
        if ((slowMetrics = this.reqSlowMetricsService.getSlowMetricsByMetric(rule.getAlert())) != null) {
            labels.addProperty("metrics_flag", "2");
            labels.addProperty("metrics", slowMetrics.getCode());
        }
        if ((errorMetricsByMetrics = ResourceUsageMetrics.getErrorMetricsByMetrics(rule.getAlert())) != null) {
            labels.addProperty("metrics_flag", errorMetricsByMetrics.getMetricsFlag());
            labels.addProperty("metrics", errorMetricsByMetrics.getCode());
        }
        jsonObject.add("labels", (JsonElement)labels);
        if (rule.getMetricType().equals(AlarmRuleMetricType.preset.getCode())) {
            String evaluationIntervalS = this.evaluationDuration + this.evaluationUnit;
            String expr = this.getExpr(rule, evaluationIntervalS, ruleData, app);
            log.info("presetMetric expr===========" + expr);
            if (StringUtils.isBlank((CharSequence)expr)) {
                log.error("getExpr error!rule:{},projectName:{}", (Object)rule.toString(), (Object)app.getProjectName());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            jsonObject.addProperty("expr", expr);
            rule.setExpr(expr);
        } else if (rule.getMetricType().equals(AlarmRuleMetricType.customer_promql.getCode())) {
            log.info("customer customize expr:projectId:{},projectName:{},expr:{}", new Object[]{app.getProjectId(), app.getProjectName(), ruleData.getExpr()});
            jsonObject.addProperty("expr", ruleData.getExpr());
            rule.setExpr(ruleData.getExpr());
        }
        String alertTeamJson = rule.getAlertTeam();
        List<String> alertMembers = ruleData.getAlertMembers();
        if (StringUtils.isBlank((CharSequence)alertTeamJson) && CollectionUtils.isEmpty(alertMembers)) {
            log.error("AlarmService.editRule error! invalid alarmTeam and alertMembers param!");
            return Result.fail((ErrorCode)ErrorCode.ALERT_TEAM_AND_ALERT_MEMBERS_BOTH_EMPTY);
        }
        if (StringUtils.isNotBlank((CharSequence)alertTeamJson)) {
            JsonArray array = (JsonArray)new Gson().fromJson(alertTeamJson, JsonArray.class);
            jsonObject.add("alert_team", (JsonElement)array);
        }
        JsonArray membersArray = new JsonArray();
        if (!CollectionUtils.isEmpty(alertMembers)) {
            membersArray = (JsonArray)new Gson().fromJson(JSON.toJSONString(alertMembers), JsonArray.class);
        }
        jsonObject.add("alert_member", (JsonElement)membersArray);
        JsonArray atMembersArray = new JsonArray();
        if (!CollectionUtils.isEmpty(ruleData.getAtMembers())) {
            atMembersArray = (JsonArray)new Gson().fromJson(JSON.toJSONString(ruleData.getAtMembers()), JsonArray.class);
        }
        jsonObject.add("alert_at_people", (JsonElement)atMembersArray);
        return this.alertServiceAdapt.editRule(rule.getAlarmId(), jsonObject, String.valueOf(rule.getIamId()), user);
    }

    public Result<JsonElement> getAlarmRuleRemote(Integer alarmId, Integer iamId, String user) {
        return this.alertServiceAdapt.getAlarmRuleRemote(alarmId, iamId, user);
    }

    public Result updateAlarm(Integer alarmId, Integer iamId, String user, String body) {
        return this.alertServiceAdapt.updateAlarm(alarmId, iamId, user, body);
    }

    public Result deleteRule(Integer alarmId, Integer iamId, String user) {
        return this.alertServiceAdapt.delRule(alarmId, String.valueOf(iamId), user);
    }

    public Result enabledRule(Integer alarmId, Integer pauseStatus, Integer iamId, String user) {
        return this.alertServiceAdapt.enableRule(alarmId, pauseStatus, String.valueOf(iamId), user);
    }

    public Result<PageData> queryRuels(Integer iamId, String user, String alert, String cname, String env, String priority, String expr, Map<String, String> labels) {
        JsonObject params = new JsonObject();
        if (!CollectionUtils.isEmpty(labels)) {
            Set<Map.Entry<String, String>> set = labels.entrySet();
            JsonArray jsonLabels = new JsonArray();
            for (Map.Entry<String, String> entry : set) {
                JsonObject jsonAlertTeam = new JsonObject();
                jsonAlertTeam.addProperty(entry.getKey(), entry.getValue());
                jsonLabels.add((JsonElement)jsonAlertTeam);
            }
            params.add("labels", (JsonElement)jsonLabels);
        }
        if (StringUtils.isNotBlank((CharSequence)alert)) {
            params.addProperty("alert", alert);
        }
        if (StringUtils.isNotBlank((CharSequence)cname)) {
            params.addProperty("cname", cname);
        }
        if (StringUtils.isNotBlank((CharSequence)env)) {
            params.addProperty("env", env);
        }
        if (StringUtils.isNotBlank((CharSequence)priority)) {
            params.addProperty("priority", priority);
        }
        if (StringUtils.isNotBlank((CharSequence)expr)) {
            params.addProperty("expr", expr);
        }
        return this.alertServiceAdapt.queryRules(params, String.valueOf(iamId), user);
    }

    public Result<JsonElement> addAlarmGroup(String alarmGroup, Integer iamId, String user) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("group", alarmGroup);
        String evaluationIntervalS = this.evaluationInterval + this.evaluationUnit;
        jsonObject.addProperty("interval", evaluationIntervalS);
        return this.alertServiceAdapt.addAlarmGroup(jsonObject, String.valueOf(iamId), user);
    }

    public Result<JsonElement> searchAlarmGroup(String alarmGroup, Integer iamId, String user) {
        return this.alertServiceAdapt.searchAlarmGroup(alarmGroup, String.valueOf(iamId), user);
    }

    public Result<PageData> searchAlertTeam(String name, String note, String manager, String oncallUser, String service, Integer iamId, String user, Integer page_no, Integer page_size) {
        return this.alertServiceAdapt.searchAlertTeam(name, note, manager, oncallUser, service, iamId, user, page_no, page_size);
    }

    public Result<PageData> queryEvents(String user, Integer treeId, String alertLevel, Long startTime, Long endTime, Integer pageNo, Integer pageSize, JsonObject labels) {
        return this.alertServiceAdapt.queryEvents(user, treeId, alertLevel, startTime, endTime, pageNo, pageSize, labels);
    }

    public Result<PageData> queryLatestEvents(Set<Integer> treeIdSet, String alertStat, String alertLevel, Long startTime, Long endTime, Integer pageNo, Integer pageSize, JsonObject labels) {
        return this.alertServiceAdapt.queryLatestEvents(treeIdSet, alertStat, alertLevel, startTime, endTime, pageNo, pageSize, labels);
    }

    public Result<JsonObject> getEventById(String user, Integer treeId, String eventId) {
        return this.alertServiceAdapt.getEventById(user, treeId, eventId);
    }

    public Result<JsonObject> resolvedEvent(String user, Integer treeId, String alertName, String comment, Long startTime, Long endTime) {
        return this.alertServiceAdapt.resolvedEvent(user, treeId, alertName, comment, startTime, endTime);
    }
}

