/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.domain.analyse.AggrCalcu;
import org.apache.ozhera.log.manager.mapper.MilogAnalyseGraphMapper;
import org.apache.ozhera.log.manager.model.bo.CalcuAggrParam;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAnalyseGraphDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataPreQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataQuery;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class AnalyseLog {
    private static final Logger log = LoggerFactory.getLogger(AnalyseLog.class);
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private EsCluster esCluster;
    @Resource
    private MilogAnalyseGraphMapper graphMapper;
    @Resource
    private AggrCalcu aggrCalcu;
    private CommonExtensionService commonExtensionService;

    public void init() {
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
    }

    public LogAnalyseDataDTO getData(LogAnalyseDataPreQuery query) throws IOException {
        return this.getData(query.getStoreId(), query.getFieldName(), query.getTypeCode(), query.getGraphParam(), query.getStartTime(), query.getEndTime());
    }

    public LogAnalyseDataDTO getData(LogAnalyseDataQuery query) throws IOException {
        MilogAnalyseGraphDO graph = (MilogAnalyseGraphDO)this.graphMapper.selectById(query.getGraphId());
        return this.getData(graph.getStoreId(), graph.getFieldName(), graph.getGraphType(), graph.getGraphParam(), query.getStartTime(), query.getEndTime());
    }

    private LogAnalyseDataDTO getData(Long storeId, String fieldName, Integer graphType, String graphParam, Long startTime, Long endTime) throws IOException {
        if (storeId == null || fieldName == null) {
            return null;
        }
        MilogLogStoreDO logStore = this.logstoreDao.queryById(storeId);
        EsService esService = this.esCluster.getEsService(logStore.getEsClusterId());
        String esIndex = this.commonExtensionService.getSearchIndex(logStore.getId(), logStore.getEsIndex());
        LogQuery logQuery = new LogQuery();
        logQuery.setStoreId(logStore.getId());
        logQuery.setStartTime(startTime);
        logQuery.setEndTime(endTime - 1000L);
        logQuery.setLogstore(logStore.getLogstoreName());
        BoolQueryBuilder boolQueryBuilder = this.commonExtensionService.commonRangeQuery(logQuery);
        AggregationBuilder aggrs = this.aggrCalcu.getAggr(new CalcuAggrParam(graphType, graphParam, fieldName, startTime, endTime));
        if (aggrs == null) {
            return null;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation(aggrs);
        searchSourceBuilder.timeout(new TimeValue(1L, TimeUnit.MINUTES));
        SearchRequest request = new SearchRequest(new String[]{esIndex});
        request.source(searchSourceBuilder);
        SearchResponse response = esService.search(request);
        return this.aggrCalcu.formatRes(graphType, response);
    }
}

