/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.job;

import cn.hutool.core.thread.ThreadUtil;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.ozhera.log.manager.service.EsIndexOperateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class EsIndexJob {
    private static final Logger log = LoggerFactory.getLogger(EsIndexJob.class);
    private static final String OPEN_TYPE = "open";
    @Value(value="$server.type")
    private String serverType;
    @Resource
    private EsIndexOperateService esIndexOperateService;

    public void init() {
        if (!Objects.equals(OPEN_TYPE, this.serverType)) {
            return;
        }
        log.info("EsIndexJob execute");
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.newNamedThreadFactory((String)"es-index", (boolean)false));
        long initDelay = 1L;
        long intervalTime = 2L;
        scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                this.esIndexOperateService.createIndexPre();
            }
            catch (Exception e) {
                log.error("EsIndexJob execute error", (Throwable)e);
            }
        }, initDelay, TimeUnit.HOURS.toMinutes(intervalTime), TimeUnit.MINUTES);
    }
}

