/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.consumer;

import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import javax.annotation.Resource;
import org.apache.ozhera.app.model.vo.HeraEnvIpVo;
import org.apache.ozhera.log.manager.service.consumer.RocketMqConsumer;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MioneRocketMqConsumer
extends RocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(MioneRocketMqConsumer.class);
    @Value(value="$rocketmq_consumer_topic")
    private String consumeTopic;
    @Resource
    private DefaultMQPushConsumer consumer;
    @Resource
    private LogTailServiceImpl logTailService;

    public void init() {
        log.info("consumer mq service init");
        try {
            this.consumer.subscribe(this.consumeTopic, "");
        }
        catch (MQClientException e) {
            log.error("Subscription IP address changed Mq consumption abnormality", (Throwable)e);
        }
        this.consumer.registerMessageListener((list, consumeOrderlyContext) -> {
            list.forEach(this::ipChangeConsumeMessage);
            return ConsumeOrderlyStatus.SUCCESS;
        });
        try {
            this.consumer.start();
        }
        catch (Exception e) {
            log.error("The Rocket Mq client starts unexpectedly when the subscription creates a project", (Throwable)e);
        }
    }

    private void ipChangeConsumeMessage(MessageExt message) {
        try {
            byte[] body = message.getBody();
            HeraEnvIpVo heraEnvIpVo = (HeraEnvIpVo)new Gson().fromJson(new String(body), HeraEnvIpVo.class);
            log.info("\u3010Dynamic expansion\u3011The message data consumed by Rocket Mq is converted into objects: {}", (Object)heraEnvIpVo.toString());
            this.logTailService.machineIpChange(heraEnvIpVo);
            log.info("\u3010Dynamic Expansion\u3011The news consumption of Rocket Mq consumption ends");
        }
        catch (Throwable ex) {
            log.error("\u3010Dynamic Scaling\u3011Rocket Mq consumption of messages is abnormal:" + ex.getMessage(), ex);
        }
    }
}

