/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.agent;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.NamedThreadFactory;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.model.meta.AgentDefine;
import org.apache.ozhera.log.api.model.meta.AppLogMeta;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.api.model.meta.MQConfig;
import org.apache.ozhera.log.api.model.vo.AgentLogProcessDTO;
import org.apache.ozhera.log.api.service.PublishConfigService;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.dao.MilogAppMiddlewareRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.domain.LogProcess;
import org.apache.ozhera.log.manager.model.bo.MilogAgentIpParam;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.env.HeraEnvIpService;
import org.apache.ozhera.log.manager.service.env.HeraEnvIpServiceFactory;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentService;
import org.apache.ozhera.log.manager.service.impl.HeraAppServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.ozhera.log.manager.service.path.LogPathMapping;
import org.apache.ozhera.log.manager.service.path.LogPathMappingFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultAgentExtensionService")
public class MilogAgentServiceImpl
implements MilogAgentService {
    private static final Logger log = LoggerFactory.getLogger(MilogAgentServiceImpl.class);
    @Resource
    private LogPathMappingFactory logPathMappingFactory;
    @Resource
    private HeraEnvIpServiceFactory heraEnvIpServiceFactory;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private MilogLogstoreDao logstoreDao;
    private Gson gson = Constant.GSON;
    @Resource
    private LogProcess logProcess;
    @Resource
    private MilogAppMiddlewareRelDao milogAppMiddlewareRelDao;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private HeraAppServiceImpl heraAppService;
    @Resource
    private LogTailServiceImpl logTailService;
    @Reference(interfaceClass=PublishConfigService.class, group="$dubbo.env.group", check=false, timeout=14000)
    private PublishConfigService publishConfigService;
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    private static final AtomicInteger COUNT_INCR;

    @Override
    public Result<List<AgentLogProcessDTO>> process(String ip) {
        List<AgentLogProcessDTO> dtoList = this.logProcess.getAgentLogProcess(ip);
        return Result.success(dtoList);
    }

    @Override
    public Result<String> configIssueAgent(String agentId, String agentIp, String agentMachine) {
        if (StringUtils.isEmpty((CharSequence)agentIp)) {
            return Result.failParam((String)"The agent IP cannot be empty");
        }
        LogCollectMeta logCollectMeta = this.queryMilogAgentConfig(agentId, agentIp, agentMachine);
        log.info("{},this ip config data:{}", (Object)agentIp, (Object)this.gson.toJson((Object)logCollectMeta));
        String k8sNodeIP = this.queryNodeIpByPodIp(agentIp);
        if (StringUtils.isNotEmpty((CharSequence)k8sNodeIP)) {
            log.info("query k8s ip succeed,ip:{},k8sNodeIP:{}", (Object)agentIp, (Object)k8sNodeIP);
            agentIp = k8sNodeIP;
        }
        ArrayList ipAddress = Lists.newArrayList();
        AgentContext.ins().map.entrySet().forEach(agentChannelEntry -> {
            String key = (String)agentChannelEntry.getKey();
            ipAddress.add(StringUtils.substringBefore((String)key, (String)":"));
        });
        log.info("agent ip list:{}", (Object)this.gson.toJson((Object)ipAddress));
        this.sengConfigToAgent(agentIp, logCollectMeta);
        return Result.success((Object)"success");
    }

    public void sengConfigToAgent(String agentIp, LogCollectMeta logCollectMeta) {
        if (CollectionUtils.isEmpty((Collection)logCollectMeta.getAppLogMetaList()) || logCollectMeta.getAppLogMetaList().stream().allMatch(appLogMeta -> CollectionUtils.isEmpty((Collection)appLogMeta.getLogPatternList()))) {
            return;
        }
        THREAD_POOL_EXECUTOR.execute(() -> this.publishConfigService.sengConfigToAgent(agentIp, logCollectMeta));
    }

    @Override
    public void publishIncrementConfig(Long tailId, Long milogAppId, List<String> ips) {
        log.info("push agent params,milogAppId:{},ips:{}", (Object)milogAppId, ips);
        if (CollectionUtils.isEmpty(ips)) {
            return;
        }
        this.printMangerInfo();
        AppBaseInfo appBaseInfo = this.heraAppService.queryById(milogAppId);
        ips.forEach(ip -> {
            AppLogMeta appLogMeta = this.assembleSingleConfig(milogAppId, this.queryLogPattern(milogAppId, (String)ip, appBaseInfo.getPlatformType()));
            LogCollectMeta logCollectMeta = new LogCollectMeta();
            logCollectMeta.setAgentIp(ip);
            logCollectMeta.setAppLogMetaList(Arrays.asList(appLogMeta));
            AgentDefine agentDefine = new AgentDefine();
            agentDefine.setFilters(new ArrayList());
            logCollectMeta.setAgentDefine(agentDefine);
            log.info("push agent config data,ip:{},{}", ip, (Object)this.gson.toJson((Object)logCollectMeta));
            this.sengConfigToAgent((String)ip, logCollectMeta);
        });
    }

    @NotNull
    private Map<String, AgentChannel> getAgentChannelMap() {
        HashMap<String, AgentChannel> logAgentMap = new HashMap<String, AgentChannel>();
        AgentContext.ins().map.forEach((k, v) -> logAgentMap.put(StringUtils.substringBefore((String)k, (String)":"), (AgentChannel)v));
        return logAgentMap;
    }

    private void printMangerInfo() {
        List remoteAddress = this.publishConfigService.getAllAgentList();
        if (COUNT_INCR.getAndIncrement() % 200 == 0) {
            log.info("The set of remote addresses for the connected agent machine is:{}", (Object)this.gson.toJson((Object)remoteAddress));
        }
    }

    public String queryNodeIpByPodIp(String ip) {
        return ip;
    }

    @Override
    public void publishIncrementDel(Long tailId, Long milogAppId, List<String> ips) {
        log.info("Delete the configuration synchronization to logAgent,tailId:{},milogAppId:{},ips:{}", new Object[]{tailId, milogAppId, this.gson.toJson(ips)});
        AppLogMeta appLogMeta = new AppLogMeta();
        LogPattern logPattern = new LogPattern();
        this.assemblyAppInfo(milogAppId, appLogMeta);
        logPattern.setLogtailId(tailId);
        logPattern.setOperateEnum(OperateEnum.DELETE_OPERATE);
        appLogMeta.setLogPatternList(Arrays.asList(logPattern));
        ips.forEach(ip -> {
            LogCollectMeta logCollectMeta = new LogCollectMeta();
            logCollectMeta.setAgentIp(ip);
            logCollectMeta.setAgentMachine("");
            logCollectMeta.setAgentId("");
            logCollectMeta.setAppLogMetaList(Arrays.asList(appLogMeta));
            this.sengConfigToAgent((String)ip, logCollectMeta);
        });
    }

    private void assemblyAppInfo(Long milogAppId, AppLogMeta appLogMeta) {
        AppBaseInfo appBaseInfo = this.heraAppService.queryById(milogAppId);
        appLogMeta.setAppId(milogAppId);
        if (null != appBaseInfo) {
            appLogMeta.setAppName(appBaseInfo.getAppName());
        }
    }

    @Override
    public void delLogCollDirectoryByIp(Long tailId, String directory, List<String> ips) {
        log.info("delLogCollDirectoryByIp logAgent,tailId:{},directory:{},ips:{}", new Object[]{tailId, directory, this.gson.toJson(ips)});
        AppLogMeta appLogMeta = new AppLogMeta();
        LogPattern logPattern = new LogPattern();
        logPattern.setLogtailId(tailId);
        logPattern.setOperateEnum(OperateEnum.DELETE_OPERATE);
        appLogMeta.setLogPatternList(Arrays.asList(logPattern));
        LogCollectMeta logCollectMeta = new LogCollectMeta();
        for (String ip : ips) {
            logCollectMeta.setAgentIp(ip);
            logCollectMeta.setDelDirectory(directory);
            logCollectMeta.setAppLogMetaList(Arrays.asList(appLogMeta));
            this.sengConfigToAgent(ip, logCollectMeta);
        }
    }

    @Override
    public Result<String> agentOfflineBatch(MilogAgentIpParam agentIpParam) {
        if (null == agentIpParam || CollectionUtils.isEmpty(agentIpParam.getIps())) {
            return Result.failParam((String)"IP cannot be empty");
        }
        return null;
    }

    @Override
    public LogCollectMeta getLogCollectMetaFromManager(String ip) {
        return this.queryMilogAgentConfig("", ip, "");
    }

    public LogCollectMeta queryMilogAgentConfig(String agentId, String agentIp, String agentMachine) {
        LogCollectMeta logCollectMeta = this.buildLogCollectMeta(agentIp);
        List<Object> appBaseInfos = Lists.newArrayList();
        List<MilogLogTailDo> logTailDos = this.milogLogtailDao.queryByIp(agentIp);
        if (CollectionUtils.isNotEmpty(logTailDos)) {
            appBaseInfos = this.heraAppService.queryByIds(logTailDos.stream().map(MilogLogTailDo::getMilogAppId).distinct().collect(Collectors.toList()));
        }
        logCollectMeta.setAppLogMetaList(appBaseInfos.stream().map(appBaseInfo -> this.assembleSingleConfig(appBaseInfo.getId().longValue(), this.queryLogPattern(appBaseInfo.getId().longValue(), agentIp, appBaseInfo.getPlatformType()))).filter(appLogMeta -> CollectionUtils.isNotEmpty((Collection)appLogMeta.getLogPatternList())).collect(Collectors.toList()));
        return logCollectMeta;
    }

    private LogCollectMeta buildLogCollectMeta(String agentIp) {
        LogCollectMeta logCollectMeta = new LogCollectMeta();
        logCollectMeta.setAgentIp(agentIp);
        logCollectMeta.setAgentMachine("");
        logCollectMeta.setAgentId("");
        return logCollectMeta;
    }

    private AppLogMeta assembleSingleConfig(Long milogAppId, List<LogPattern> logPatternList) {
        AppLogMeta appLogMeta = new AppLogMeta();
        this.assemblyAppInfo(milogAppId, appLogMeta);
        appLogMeta.setLogPatternList(logPatternList);
        return appLogMeta;
    }

    private MQConfig decorateMQConfig(MilogLogTailDo milogLogtailDo) {
        MQConfig mqConfig = new MQConfig();
        try {
            Long mqResourceId = this.logstoreDao.queryById(milogLogtailDo.getStoreId()).getMqResourceId();
            List<MilogAppMiddlewareRel> milogAppMiddlewareRels = this.milogAppMiddlewareRelDao.queryByCondition(milogLogtailDo.getMilogAppId(), mqResourceId, milogLogtailDo.getId());
            if (CollectionUtils.isEmpty(milogAppMiddlewareRels)) {
                milogAppMiddlewareRels = this.milogAppMiddlewareRelDao.queryByCondition(milogLogtailDo.getMilogAppId(), null, milogLogtailDo.getId());
            }
            MilogAppMiddlewareRel milogAppMiddlewareRel = milogAppMiddlewareRels.get(milogAppMiddlewareRels.size() - 1);
            MilogMiddlewareConfig middlewareConfig = this.milogMiddlewareConfigDao.queryById(milogAppMiddlewareRel.getMiddlewareId());
            mqConfig.setClusterInfo(middlewareConfig.getNameServer());
            this.fillMqConfigData(mqConfig, MQSourceEnum.queryName((Integer)middlewareConfig.getType()), middlewareConfig, milogAppMiddlewareRel.getConfig());
        }
        catch (Exception e) {
            log.error("The assembly MQ configuration information is abnormal,data:{}", (Object)this.gson.toJson((Object)milogLogtailDo), (Object)e);
        }
        return mqConfig;
    }

    private void fillMqConfigData(MQConfig mqConfig, String typeName, MilogMiddlewareConfig middlewareConfig, MilogAppMiddlewareRel.Config config) {
        mqConfig.setType(typeName);
        mqConfig.setAk(middlewareConfig.getAk());
        mqConfig.setProducerGroup(config.getConsumerGroup());
        mqConfig.setSk(middlewareConfig.getSk());
        mqConfig.setTopic(config.getTopic());
        mqConfig.setTag(config.getTag());
        mqConfig.setPartitionCnt(config.getPartitionCnt());
        mqConfig.setEsConsumerGroup(config.getEsConsumerGroup());
        mqConfig.setBatchSendSize(config.getBatchSendSize());
    }

    private List<LogPattern> queryLogPattern(Long milogAppId, String agentIp, Integer type) {
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryByAppIdAgentIp(milogAppId, agentIp);
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            return milogLogtailDos.stream().map(milogLogtailDo -> {
                log.info("assemble data:{}", (Object)this.gson.toJson((Object)milogAppId));
                LogPattern logPattern = this.generateLogPattern((MilogLogTailDo)milogLogtailDo);
                logPattern.setIps((List)Lists.newArrayList((Object[])new String[]{agentIp}));
                logPattern.setIpDirectoryRel((List)Lists.newArrayList((Object[])new LogPattern.IPRel[]{LogPattern.IPRel.builder().ip(agentIp).build()}));
                LogPathMapping logPathMapping = this.logPathMappingFactory.queryLogPathMappingByAppType(type);
                HeraEnvIpService heraEnvIpService = this.heraEnvIpServiceFactory.getHeraEnvIpServiceByAppType(type);
                try {
                    logPattern.setLogPattern(logPathMapping.getLogPath(milogLogtailDo.getLogPath(), null));
                    logPattern.setLogSplitExpress(logPathMapping.getLogPath(milogLogtailDo.getLogSplitExpress(), null));
                    logPattern.setIpDirectoryRel(heraEnvIpService.queryActualIps(milogLogtailDo.getIps(), agentIp, milogLogtailDo.getLogPath()));
                }
                catch (Exception e) {
                    log.error("assemble log path data error:", (Throwable)e);
                }
                MQConfig mqConfig = this.decorateMQConfig((MilogLogTailDo)milogLogtailDo);
                logPattern.setMQConfig(mqConfig);
                return logPattern;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private LogPattern generateLogPattern(MilogLogTailDo milogLogtailDo) {
        LogPattern logPattern = new LogPattern();
        MilogLogStoreDO milogLogstoreDO = this.logstoreDao.queryById(milogLogtailDo.getStoreId());
        logPattern.setLogtailId(milogLogtailDo.getId());
        logPattern.setTailName(milogLogtailDo.getTail());
        logPattern.setLogPattern(milogLogtailDo.getLogPath());
        logPattern.setLogSplitExpress(milogLogtailDo.getLogSplitExpress());
        logPattern.setFilters(milogLogtailDo.getFilter());
        logPattern.setFirstLineReg(milogLogtailDo.getFirstLineReg());
        if (null != milogLogstoreDO && null != milogLogstoreDO.getLogType()) {
            logPattern.setLogType(milogLogstoreDO.getLogType());
            if (LogTypeEnum.NGINX.getType().equals(milogLogstoreDO.getLogType())) {
                logPattern.setLogPattern(milogLogtailDo.getLogPath());
            }
        }
        String tag = Utils.createTag(milogLogtailDo.getSpaceId(), milogLogtailDo.getStoreId(), milogLogtailDo.getId());
        logPattern.setPatternCode(tag);
        return logPattern;
    }

    static {
        COUNT_INCR = new AtomicInteger(0);
        THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(6, 20, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(200), (ThreadFactory)new NamedThreadFactory("coll-base-data-start", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        THREAD_POOL_EXECUTOR.allowCoreThreadTimeOut(true);
    }
}

