/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.common;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultCommonExtensionService")
public class DefaultCommonExtensionService
implements CommonExtensionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommonExtensionService.class);

    @Override
    public String getLogManagePrefix() {
        return "log_manage_";
    }

    @Override
    public String getHeraLogStreamServerName() {
        return "hera_log_stream";
    }

    @Override
    public String getMachineRoomName(String machineRoomEn) {
        return MachineRegionEnum.queryCnByEn((String)machineRoomEn);
    }

    @Override
    public boolean middlewareEnumValid(Integer type) {
        return Arrays.stream(MQSourceEnum.values()).map(MQSourceEnum::getCode).toList().contains(type);
    }

    @Override
    public BoolQueryBuilder commonRangeQuery(LogQuery logQuery) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from((Object)logQuery.getStartTime()).to((Object)logQuery.getEndTime()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"storeId", (Object)logQuery.getStoreId()));
        return boolQueryBuilder;
    }

    @Override
    public String getSortedKey(LogQuery logQuery, String sortedKey) {
        return sortedKey;
    }

    @Override
    public TermQueryBuilder multipleChooseBuilder(QueryTypeEnum queryTypeEnum, Long storeId, String chooseVal) {
        if (QueryTypeEnum.ID == queryTypeEnum) {
            return QueryBuilders.termQuery((String)"tailId", (String)chooseVal);
        }
        return QueryBuilders.termQuery((String)"tail", (String)chooseVal);
    }

    @Override
    public String queryDateHistogramField(Long storeId) {
        return "timestamp";
    }

    @Override
    public String getSearchIndex(Long logStoreId, String esIndexName) {
        return esIndexName;
    }

    @Override
    public String getSpaceDataId(Long spaceId) {
        return this.getLogManagePrefix() + "create_namespace_config";
    }

    @Override
    public List<String> queryMachineRegions() {
        return Arrays.stream(MachineRegionEnum.values()).map(MachineRegionEnum::getEn).collect(Collectors.toList());
    }

    public static enum QueryTypeEnum {
        ID,
        TEXT;

    }
}

