/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Service;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.api.service.AgentConfigService;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentService;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@com.xiaomi.youpin.docean.plugin.dubbo.anno.Service(interfaceClass=AgentConfigService.class, group="$dubbo.env.group")
public class AgentConfigServiceImpl
implements AgentConfigService {
    private static final Logger log = LoggerFactory.getLogger(AgentConfigServiceImpl.class);
    private MilogAgentService milogAgentService;

    public void init() {
        this.milogAgentService = MilogAgentServiceFactory.getAgentExtensionService();
    }

    public LogCollectMeta getLogCollectMetaFromManager(String ip) {
        log.info("getLogCollectMetaFromManager begin:{}", (Object)ip);
        try {
            long begin = System.currentTimeMillis();
            if (null == this.milogAgentService) {
                this.init();
            }
            LogCollectMeta logCollectMeta = this.milogAgentService.getLogCollectMetaFromManager(ip);
            log.info("getLogCollectMetaFromManager end:{} {} {}", new Object[]{ip, new Gson().toJson((Object)logCollectMeta), System.currentTimeMillis() - begin});
            return logCollectMeta;
        }
        catch (Exception e) {
            log.error("getLogCollectMetaFromManager error,ip:{}", (Object)ip, (Object)e);
            return new LogCollectMeta();
        }
    }
}

