/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos;

import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class InitService {
    private static final Logger log = LoggerFactory.getLogger(InitService.class);
    @Resource
    private NacosNaming nacosNaming;
    @Value(value="$serverNameHttp", defaultValue="")
    private String serverNameHttp;
    @Value(value="$serverPort", defaultValue="")
    private String httpPort;
    @Value(value="$dubbo.group", defaultValue="")
    private String group;

    @PostConstruct
    public void init() {
        String host = System.getenv("host.ip") == null ? NetUtils.getLocalHost() : System.getenv("host.ip");
        String port = this.httpPort;
        String appName = this.serverNameHttp;
        try {
            this.nacosNaming.registerInstance(appName, host, Integer.valueOf(port).intValue(), this.group);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    System.out.println("stop");
                    this.nacosNaming.deregisterInstance(appName, host, Integer.valueOf(port).intValue(), this.group);
                }
                catch (Exception e) {
                    log.error("init service err:{}", (Object)e.getMessage(), (Object)e);
                }
            }));
        }
        catch (Exception e) {
            log.error("init service err:{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

