/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.xiaomi.mone.tpc.login.util.HostUtil;
import com.xiaomi.mone.tpc.login.vo.AuthTokenVo;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    public static String getLogoutUrlWithToken(String authToken, String logoutUrl) {
        if (StringUtils.isBlank((CharSequence)authToken) || StringUtils.isBlank((CharSequence)logoutUrl)) {
            logger.error("getLogoutUrlWithToken authToken={}, logoutUrl={}", (Object)authToken, (Object)logoutUrl);
            return null;
        }
        try {
            StringBuilder pageUrl = new StringBuilder();
            pageUrl.append(logoutUrl);
            URL url = new URL(logoutUrl);
            String params = url.getQuery();
            if (StringUtils.isBlank((CharSequence)params)) {
                if (logoutUrl.endsWith("?")) {
                    pageUrl.append("TPC_TOKEN").append("=").append(authToken);
                } else {
                    pageUrl.append("?").append("TPC_TOKEN").append("=").append(authToken);
                }
            } else {
                pageUrl.append("&").append("TPC_TOKEN").append("=").append(authToken);
            }
            return pageUrl.toString();
        }
        catch (Throwable e) {
            logger.error("getLogoutUrlWithToken authToken={}, logoutUrl={}", new Object[]{authToken, logoutUrl, e});
            return null;
        }
    }

    public static void setCookie(HttpServletRequest request, AuthUserVo userVo, ServletResponse servletResponse) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Cookie cookie = new Cookie("TPC_TOKEN", userVo.getToken());
        cookie.setPath("/");
        cookie.setMaxAge(userVo.getExprTime().intValue());
        String origin = Optional.ofNullable(request.getHeader("Origin")).orElse(request.getHeader("Host"));
        String domain = HostUtil.getDomain(origin);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static final AuthTokenVo parseAuthToken(HttpServletRequest request) {
        String[] kvArr;
        String authToken = request.getParameter("TPC_TOKEN");
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(authToken);
            tokenVo.setFromCookie(false);
            return tokenVo;
        }
        String referer = request.getHeader("Referer");
        logger.info("referer={}", (Object)referer);
        if (StringUtils.isBlank((CharSequence)referer)) {
            return TokenUtil.getAuthToken((ServletRequest)request);
        }
        String[] arr = referer.split("\\?");
        if (arr.length != 2) {
            return TokenUtil.getAuthToken((ServletRequest)request);
        }
        HashMap params = new HashMap();
        for (String kv : kvArr = arr[1].split("\\&")) {
            String[] subKvArr = kv.split("\\=");
            if (subKvArr.length != 2 || !subKvArr[0].equals("TPC_TOKEN")) continue;
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(subKvArr[1]);
            tokenVo.setFromCookie(false);
            return tokenVo;
        }
        return TokenUtil.getAuthToken((ServletRequest)request);
    }

    private static final AuthTokenVo getAuthToken(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (request == null || request.getCookies() == null || request.getCookies().length == 0) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals("TPC_TOKEN")) continue;
            AuthTokenVo tokenVo = new AuthTokenVo();
            tokenVo.setAuthToken(cookie.getValue());
            tokenVo.setFromCookie(true);
            return tokenVo;
        }
        return null;
    }
}

