/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchManager<T extends HasMetadata>
implements Watch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatchManager.class);
    final Watcher<T> watcher;
    final AtomicReference<String> resourceVersion;
    final AtomicBoolean forceClosed;
    private final int reconnectLimit;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    final AtomicInteger currentReconnectAttempt;
    private ScheduledFuture<?> reconnectAttempt;
    protected final HttpClient client;
    private BaseOperation<T, ?, ?> baseOperation;
    private ListOptions listOptions;
    private URL requestUrl;
    private final AtomicBoolean reconnectPending = new AtomicBoolean(false);
    private final boolean receiveBookmarks;

    AbstractWatchManager(Watcher<T> watcher, BaseOperation<T, ?, ?> baseOperation, ListOptions listOptions, int reconnectLimit, int reconnectInterval, int maxIntervalExponent, Supplier<HttpClient> clientSupplier) throws MalformedURLException {
        this.watcher = watcher;
        this.reconnectLimit = reconnectLimit;
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(reconnectInterval, maxIntervalExponent);
        this.resourceVersion = new AtomicReference<String>(listOptions.getResourceVersion());
        this.currentReconnectAttempt = new AtomicInteger(0);
        this.forceClosed = new AtomicBoolean();
        this.receiveBookmarks = Boolean.TRUE.equals(listOptions.getAllowWatchBookmarks());
        if (listOptions.getAllowWatchBookmarks() == null) {
            listOptions.setAllowWatchBookmarks(Boolean.valueOf(true));
        }
        this.baseOperation = baseOperation;
        this.requestUrl = baseOperation.getNamespacedUrl();
        this.listOptions = listOptions;
        this.client = clientSupplier.get();
        this.runWatch();
    }

    protected abstract void run(URL var1, Map<String, String> var2);

    protected abstract void closeRequest();

    final void close(WatcherException cause) {
        this.closeRequest();
        if (this.forceClosed.get()) {
            logger.debug("Ignoring duplicate firing of onClose event");
        } else {
            boolean success = false;
            try {
                this.watcher.onClose(cause);
                success = true;
            }
            finally {
                if (success || !this.watcher.reconnecting()) {
                    this.forceClosed.set(true);
                }
            }
        }
        this.close();
    }

    final void closeEvent() {
        if (this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
            return;
        }
        this.watcher.onClose();
    }

    final synchronized void cancelReconnect() {
        if (this.reconnectAttempt != null) {
            this.reconnectAttempt.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleReconnect() {
        if (!this.reconnectPending.compareAndSet(false, true)) {
            logger.debug("Reconnect already scheduled");
            return;
        }
        if (this.isForceClosed()) {
            logger.debug("Ignoring error for already closed/closing connection");
            return;
        }
        if (this.cannotReconnect()) {
            this.close(new WatcherException("Exhausted reconnects"));
            return;
        }
        logger.debug("Scheduling reconnect task");
        long delay = this.nextReconnectInterval();
        AbstractWatchManager abstractWatchManager = this;
        synchronized (abstractWatchManager) {
            this.reconnectAttempt = Utils.schedule(Utils.getCommonExecutorSerive(), () -> {
                try {
                    this.runWatch();
                    if (this.isForceClosed()) {
                        this.closeRequest();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception in reconnect", (Throwable)e);
                    this.close(new WatcherException("Unhandled exception in reconnect attempt", e));
                }
                finally {
                    this.reconnectPending.set(false);
                }
            }, delay, TimeUnit.MILLISECONDS);
            if (this.isForceClosed()) {
                this.cancelReconnect();
            }
        }
    }

    final boolean cannotReconnect() {
        return !this.watcher.reconnecting() && this.currentReconnectAttempt.get() >= this.reconnectLimit && this.reconnectLimit >= 0;
    }

    final long nextReconnectInterval() {
        int exponentOfTwo = this.currentReconnectAttempt.getAndIncrement();
        long ret = this.retryIntervalCalculator.getInterval(exponentOfTwo);
        logger.debug("Current reconnect backoff is {} milliseconds (T{})", (Object)ret, (Object)exponentOfTwo);
        return ret;
    }

    void resetReconnectAttempts() {
        this.currentReconnectAttempt.set(0);
    }

    boolean isForceClosed() {
        return this.forceClosed.get();
    }

    void eventReceived(Watcher.Action action, HasMetadata resource) {
        if (!this.receiveBookmarks && action == Watcher.Action.BOOKMARK) {
            return;
        }
        if (resource != null && !this.baseOperation.getType().isAssignableFrom(resource.getClass())) {
            resource = (HasMetadata)Serialization.jsonMapper().convertValue((Object)resource, this.baseOperation.getType());
        }
        this.watcher.eventReceived(action, resource);
    }

    void updateResourceVersion(String newResourceVersion) {
        this.resourceVersion.set(newResourceVersion);
    }

    protected void runWatch() {
        this.listOptions.setResourceVersion(this.resourceVersion.get());
        URL url = BaseOperation.appendListOptionParams(this.requestUrl, this.listOptions);
        String origin = this.requestUrl.getProtocol() + "://" + this.requestUrl.getHost();
        if (this.requestUrl.getPort() != -1) {
            origin = origin + ":" + this.requestUrl.getPort();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Origin", origin);
        logger.debug("Watching {}...", (Object)url);
        this.closeRequest();
        this.run(url, headers);
    }

    @Override
    public void close() {
        logger.debug("Force closing the watch {}", (Object)this);
        this.closeEvent();
        this.closeRequest();
        this.cancelReconnect();
    }

    protected WatchEvent readWatchEvent(String messageSource) {
        WatchEvent event = Serialization.unmarshal(messageSource, WatchEvent.class);
        KubernetesResource object = null;
        if (event != null) {
            object = event.getObject();
        }
        if (object == null) {
            object = Serialization.unmarshal(messageSource, KubernetesResource.class);
            if (event == null) {
                event = new WatchEvent(object, "MODIFIED");
            } else {
                event.setObject(object);
            }
        }
        if (event.getType() == null) {
            event.setType("MODIFIED");
        }
        return event;
    }

    protected void onMessage(String message) {
        try {
            WatchEvent event = this.readWatchEvent(message);
            KubernetesResource object = event.getObject();
            if (object instanceof HasMetadata) {
                HasMetadata obj = (HasMetadata)object;
                this.updateResourceVersion(obj.getMetadata().getResourceVersion());
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                this.eventReceived(action, obj);
            } else if (object instanceof KubernetesResourceList) {
                KubernetesResourceList list = (KubernetesResourceList)object;
                this.updateResourceVersion(list.getMetadata().getResourceVersion());
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                List items = list.getItems();
                if (items != null) {
                    for (HasMetadata item : items) {
                        this.eventReceived(action, item);
                    }
                }
            } else if (object instanceof Status) {
                Status status = (Status)object;
                this.onStatus(status);
            } else {
                logger.error("Unknown message received: {}", (Object)message);
            }
        }
        catch (ClassCastException e) {
            logger.error("Received wrong type of object for watch", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid event type", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unhandled exception encountered in watcher event handler", (Throwable)e);
        }
    }

    protected boolean onStatus(Status status) {
        if (status.getCode() == 410) {
            this.close(new WatcherException(status.getMessage(), new KubernetesClientException(status)));
            return true;
        }
        this.eventReceived(Watcher.Action.ERROR, null);
        logger.error("Error received: {}", (Object)status);
        return false;
    }
}

