/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileUtils {
    public static String tmp() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String home() {
        return System.getProperty("user.home");
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + String.valueOf(file));
                }
                String message = "Unable to delete file: " + String.valueOf(file);
                throw new IOException(message);
            }
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + String.valueOf(directory) + ".";
            throw new IOException(message);
        }
    }
}

