/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.xiaomi.youpin.docean.Mvc;
import com.xiaomi.youpin.docean.bo.MvcConfig;
import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.ContextHolder;
import com.xiaomi.youpin.docean.mvc.HttpRequestMethod;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import com.xiaomi.youpin.docean.mvc.MvcRequest;
import com.xiaomi.youpin.docean.mvc.MvcResponse;
import com.xiaomi.youpin.docean.mvc.MvcResult;
import com.xiaomi.youpin.docean.mvc.WsRequest;
import com.xiaomi.youpin.docean.mvc.common.MvcConst;
import com.xiaomi.youpin.docean.mvc.download.Download;
import com.xiaomi.youpin.docean.mvc.html.Html;
import com.xiaomi.youpin.docean.mvc.upload.MvcUpload;
import com.xiaomi.youpin.docean.mvc.util.ExceptionUtil;
import com.xiaomi.youpin.docean.mvc.util.GsonUtils;
import com.xiaomi.youpin.docean.mvc.util.MethodFinder;
import com.xiaomi.youpin.docean.mvc.util.RequestUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvcRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MvcRunnable.class);
    private MvcContext context;
    private MvcRequest request;
    private MvcResponse response;
    private MvcConfig config;
    private ConcurrentHashMap<String, HttpRequestMethod> requestMethodMap;
    private Mvc mvc;
    private static Gson gson = new Gson();

    public MvcRunnable(Mvc mvc, MvcContext context, MvcRequest request, MvcResponse response, ConcurrentHashMap<String, HttpRequestMethod> requestMethodMap) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestMethodMap = requestMethodMap;
        this.mvc = mvc;
        this.config = this.mvc.getMvcConfig();
    }

    public MvcRunnable(Mvc mvc, HttpServerConfig config, ChannelHandlerContext ctx, FullHttpRequest httpRequest, String path, byte[] body, ConcurrentHashMap<String, HttpRequestMethod> requestMethodMap) {
        String method = httpRequest.method().name();
        this.context = new MvcContext();
        this.request = new MvcRequest();
        this.response = new MvcResponse();
        this.context.setRequest(httpRequest);
        this.context.setMethod(method);
        this.context.setHandlerContext(ctx);
        this.context.setCookie(config.isCookie());
        this.request.setHeaders(RequestUtils.headers(httpRequest));
        this.request.setUri(httpRequest.uri());
        this.context.setHeaders(this.request.getHeaders());
        this.context.setVirtualThread(mvc.getMvcConfig().isVirtualThread());
        this.context.setPath(path);
        this.context.setAllowCross(mvc.getMvcConfig().isAllowCross());
        this.request.setMethod(method);
        this.request.setPath(path);
        this.request.setBody(body);
        this.response.setCtx(ctx);
        this.mvc = mvc;
        this.config = this.mvc.getMvcConfig();
        this.requestMethodMap = requestMethodMap;
    }

    @Override
    public void run() {
        Safe.run(() -> {
            log.debug("call mvc path:{}", (Object)this.request.getPath());
            if (this.mvc.getMvcConfig().isVirtualThread()) {
                ScopedValue.where(MvcConst.MVC_CONTEXT, this.context).run(() -> this.call());
            } else {
                ContextHolder.getContext().set(this.context);
                try {
                    this.call();
                }
                finally {
                    ContextHolder.getContext().close();
                }
            }
        }, ex -> {
            MvcResult mr = new MvcResult();
            Throwable unwrapThrowable = ExceptionUtil.unwrapThrowable(ex);
            mr.setMessage(unwrapThrowable.toString());
            mr.setCode(500);
            this.response.writeAndFlush(this.context, gson.toJson(mr));
        });
    }

    private void call() {
        if (this.context.isWebsocket()) {
            String reqBody = new String(this.request.getBody());
            JsonElement element = GsonUtils.gson.toJsonTree((Object)reqBody);
            if (element.isJsonPrimitive()) {
                this.request.setPath("/ws");
            }
            if (element.isJsonObject()) {
                WsRequest req = (WsRequest)GsonUtils.gson.fromJson(new String(this.request.getBody()), WsRequest.class);
                this.request.setPath(req.getPath());
                this.request.setBody(GsonUtils.gson.toJson(req.getParams()).getBytes());
            }
        }
        if (this.isFaviconIco(this.request)) {
            this.response.writeAndFlush(this.context, HttpResponseStatus.NOT_FOUND, "");
            return;
        }
        String path = this.request.getPath();
        if (this.config.isOpenStaticFile() && Html.isHtmlFile(path)) {
            String content = Html.view(this.config.getStaticFilePath() + path);
            if (StringUtils.isEmpty(content)) {
                this.sendNotFoundResponse();
                return;
            }
            if (path.endsWith(".html")) {
                this.context.setContentType("text/html; charset=utf-8");
            }
            this.response.writeAndFlush(this.context, content);
            return;
        }
        if (this.isDownload(path) && this.mvc.getMvcConfig().isDownload()) {
            Download.download(this.context, this.request, this.response);
            return;
        }
        if (MvcRunnable.isUpload(path)) {
            MvcUpload.upload(this.mvc, this.request, this.response, this.context);
            return;
        }
        HttpRequestMethod method = MethodFinder.find(path, this.requestMethodMap);
        if (null != method) {
            this.mvc.callMethod(this.context, this.request, this.response, new MvcResult<Object>(), method);
            return;
        }
        if (!path.equals("/service")) {
            this.sendNotFoundResponse();
            return;
        }
        this.mvc.callService(this.context, this.request, this.response);
    }

    private void sendNotFoundResponse() {
        MvcResult result = new MvcResult();
        result.setCode(HttpResponseStatus.NOT_FOUND.code());
        result.setMessage(HttpResponseStatus.NOT_FOUND.reasonPhrase());
        this.response.writeAndFlush(this.context, gson.toJson(result));
    }

    private boolean isDownload(String path) {
        return path.equals("/download");
    }

    public static final boolean isUpload(String path) {
        return path.equals("/upload");
    }

    private boolean isFaviconIco(MvcRequest request) {
        return request.getPath().equals("/favicon.ico");
    }
}

