/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.http2;

import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.HttpHandlerRead;
import com.xiaomi.youpin.docean.mvc.http2.Http1Handler;
import com.xiaomi.youpin.docean.mvc.http2.Http2OrHttpHandler;
import com.xiaomi.youpin.docean.mvc.http2.Http2UpgradeCodecFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;

public class Http2ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final int maxHttpContentLength;
    private HttpServerConfig config;

    public Http2ServerInitializer(SslContext sslCtx, HttpServerConfig config) {
        this(sslCtx, 16384);
        this.config = config;
    }

    public Http2ServerInitializer(SslContext sslCtx, int maxHttpContentLength) {
        this.sslCtx = sslCtx;
        this.maxHttpContentLength = ObjectUtil.checkPositiveOrZero((int)maxHttpContentLength, (String)"maxHttpContentLength");
    }

    public void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            this.configureClearText2(ch);
        }
    }

    private void configureSsl(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new Http2OrHttpHandler(this.config)});
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        p.addLast(new ChannelHandler[]{sourceCodec});
        p.addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, (HttpServerUpgradeHandler.UpgradeCodecFactory)new Http2UpgradeCodecFactory(this.config))});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                System.err.println("Directly talking: " + String.valueOf(msg.protocolVersion()) + " (no upgrade was attempted)");
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.addAfter(ctx.name(), null, (ChannelHandler)new Http1Handler(Http2ServerInitializer.this.config));
                pipeline.replace((ChannelHandler)this, null, (ChannelHandler)new HttpObjectAggregator(Http2ServerInitializer.this.maxHttpContentLength));
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }});
        p.addLast(new ChannelHandler[]{new UserEventLogger()});
    }

    private void configureClearText2(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()});
        ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

                    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
                        HttpHandlerRead.read(ctx, msg, Http2ServerInitializer.this.config);
                    }
                }});
            }
        })});
        ch.pipeline().addLast(new ChannelHandler[]{new UserEventLogger()});
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            System.out.println("User Event Triggered: " + String.valueOf(evt));
            ctx.fireUserEventTriggered(evt);
        }
    }
}

