/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private Properties properties;

    private Config() {
        InputStream is = Config.class.getClassLoader().getResourceAsStream("config.properties");
        this.properties = new Properties();
        try {
            this.properties.load(is);
        }
        catch (IOException e) {
            log.warn("load config error:{}", (Object)e.getMessage());
        }
    }

    public static final Config ins() {
        return LazyHolder.ins;
    }

    public String get(String key, String defaultValue) {
        return this.properties.getOrDefault((Object)key, defaultValue).toString().trim();
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private static final class LazyHolder {
        private static Config ins = new Config();

        private LazyHolder() {
        }
    }
}

