/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.keyvalue.annotation.KeySpace;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

enum AnnotationBasedKeySpaceResolver implements KeySpaceResolver
{
    INSTANCE;


    @Override
    @Nullable
    public String resolveKeySpace(Class<?> type) {
        Assert.notNull(type, (String)"Type for keyspace for null!");
        Class userClass = ClassUtils.getUserClass(type);
        Object keySpace = AnnotationBasedKeySpaceResolver.getKeySpace(userClass);
        return keySpace != null ? keySpace.toString() : null;
    }

    @Nullable
    private static Object getKeySpace(Class<?> type) {
        KeySpace keyspace = (KeySpace)AnnotatedElementUtils.findMergedAnnotation(type, KeySpace.class);
        if (keyspace != null) {
            return AnnotationUtils.getValue((Annotation)keyspace);
        }
        return null;
    }
}

