/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.spi.MappingExclusionProvider;

class DefaultMappingExclusionProvider
implements MappingExclusionProvider {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");

    DefaultMappingExclusionProvider() {
    }

    @Override
    public boolean isExcluded(TypeElement typeElement) {
        Name name = typeElement.getQualifiedName();
        return name.length() != 0 && this.isFullyQualifiedNameExcluded(name);
    }

    protected boolean isFullyQualifiedNameExcluded(Name name) {
        return JAVA_JAVAX_PACKAGE.matcher(name).matches();
    }
}

