<!--

 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.

-->
# polaris.catalog
Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.0
- Generator version: 7.8.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import polaris.catalog
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import polaris.catalog
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import polaris.catalog
from polaris.catalog.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = polaris.catalog.Configuration(
    host = "https://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure Bearer authorization: BearerAuth
configuration = polaris.catalog.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with polaris.catalog.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = polaris.catalog.IcebergCatalogAPI(api_client)
    prefix = 'prefix_example' # str | An optional prefix in the path
    commit_transaction_request = polaris.catalog.CommitTransactionRequest() # CommitTransactionRequest | Commit updates to multiple tables in an atomic operation  A commit for a single table consists of a table identifier with requirements and updates. Requirements are assertions that will be validated before attempting to make and commit changes. For example, `assert-ref-snapshot-id` will check that a named ref's snapshot ID has a certain value.  Updates are changes to make to table metadata. For example, after asserting that the current main ref is at the expected snapshot, a commit may add a new child snapshot and set the ref to the new snapshot id.

    try:
        # Commit updates to multiple tables in an atomic operation
        api_instance.commit_transaction(prefix, commit_transaction_request)
    except ApiException as e:
        print("Exception when calling IcebergCatalogAPI->commit_transaction: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*IcebergCatalogAPI* | [**commit_transaction**](docs/IcebergCatalogAPI.md#commit_transaction) | **POST** /v1/{prefix}/transactions/commit | Commit updates to multiple tables in an atomic operation
*IcebergCatalogAPI* | [**create_namespace**](docs/IcebergCatalogAPI.md#create_namespace) | **POST** /v1/{prefix}/namespaces | Create a namespace
*IcebergCatalogAPI* | [**create_table**](docs/IcebergCatalogAPI.md#create_table) | **POST** /v1/{prefix}/namespaces/{namespace}/tables | Create a table in the given namespace
*IcebergCatalogAPI* | [**create_view**](docs/IcebergCatalogAPI.md#create_view) | **POST** /v1/{prefix}/namespaces/{namespace}/views | Create a view in the given namespace
*IcebergCatalogAPI* | [**drop_namespace**](docs/IcebergCatalogAPI.md#drop_namespace) | **DELETE** /v1/{prefix}/namespaces/{namespace} | Drop a namespace from the catalog. Namespace must be empty.
*IcebergCatalogAPI* | [**drop_table**](docs/IcebergCatalogAPI.md#drop_table) | **DELETE** /v1/{prefix}/namespaces/{namespace}/tables/{table} | Drop a table from the catalog
*IcebergCatalogAPI* | [**drop_view**](docs/IcebergCatalogAPI.md#drop_view) | **DELETE** /v1/{prefix}/namespaces/{namespace}/views/{view} | Drop a view from the catalog
*IcebergCatalogAPI* | [**list_namespaces**](docs/IcebergCatalogAPI.md#list_namespaces) | **GET** /v1/{prefix}/namespaces | List namespaces, optionally providing a parent namespace to list underneath
*IcebergCatalogAPI* | [**list_tables**](docs/IcebergCatalogAPI.md#list_tables) | **GET** /v1/{prefix}/namespaces/{namespace}/tables | List all table identifiers underneath a given namespace
*IcebergCatalogAPI* | [**list_views**](docs/IcebergCatalogAPI.md#list_views) | **GET** /v1/{prefix}/namespaces/{namespace}/views | List all view identifiers underneath a given namespace
*IcebergCatalogAPI* | [**load_namespace_metadata**](docs/IcebergCatalogAPI.md#load_namespace_metadata) | **GET** /v1/{prefix}/namespaces/{namespace} | Load the metadata properties for a namespace
*IcebergCatalogAPI* | [**load_table**](docs/IcebergCatalogAPI.md#load_table) | **GET** /v1/{prefix}/namespaces/{namespace}/tables/{table} | Load a table from the catalog
*IcebergCatalogAPI* | [**load_view**](docs/IcebergCatalogAPI.md#load_view) | **GET** /v1/{prefix}/namespaces/{namespace}/views/{view} | Load a view from the catalog
*IcebergCatalogAPI* | [**namespace_exists**](docs/IcebergCatalogAPI.md#namespace_exists) | **HEAD** /v1/{prefix}/namespaces/{namespace} | Check if a namespace exists
*IcebergCatalogAPI* | [**register_table**](docs/IcebergCatalogAPI.md#register_table) | **POST** /v1/{prefix}/namespaces/{namespace}/register | Register a table in the given namespace using given metadata file location
*IcebergCatalogAPI* | [**rename_table**](docs/IcebergCatalogAPI.md#rename_table) | **POST** /v1/{prefix}/tables/rename | Rename a table from its current name to a new name
*IcebergCatalogAPI* | [**rename_view**](docs/IcebergCatalogAPI.md#rename_view) | **POST** /v1/{prefix}/views/rename | Rename a view from its current name to a new name
*IcebergCatalogAPI* | [**replace_view**](docs/IcebergCatalogAPI.md#replace_view) | **POST** /v1/{prefix}/namespaces/{namespace}/views/{view} | Replace a view
*IcebergCatalogAPI* | [**report_metrics**](docs/IcebergCatalogAPI.md#report_metrics) | **POST** /v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics | Send a metrics report to this endpoint to be processed by the backend
*IcebergCatalogAPI* | [**send_notification**](docs/IcebergCatalogAPI.md#send_notification) | **POST** /v1/{prefix}/namespaces/{namespace}/tables/{table}/notifications | Sends a notification to the table
*IcebergCatalogAPI* | [**table_exists**](docs/IcebergCatalogAPI.md#table_exists) | **HEAD** /v1/{prefix}/namespaces/{namespace}/tables/{table} | Check if a table exists
*IcebergCatalogAPI* | [**update_properties**](docs/IcebergCatalogAPI.md#update_properties) | **POST** /v1/{prefix}/namespaces/{namespace}/properties | Set or remove properties on a namespace
*IcebergCatalogAPI* | [**update_table**](docs/IcebergCatalogAPI.md#update_table) | **POST** /v1/{prefix}/namespaces/{namespace}/tables/{table} | Commit updates to a table
*IcebergCatalogAPI* | [**view_exists**](docs/IcebergCatalogAPI.md#view_exists) | **HEAD** /v1/{prefix}/namespaces/{namespace}/views/{view} | Check if a view exists
*IcebergConfigurationAPI* | [**get_config**](docs/IcebergConfigurationAPI.md#get_config) | **GET** /v1/config | List all catalog configuration settings
*IcebergOAuth2API* | [**get_token**](docs/IcebergOAuth2API.md#get_token) | **POST** /v1/oauth/tokens | Get a token using an OAuth2 flow


## Documentation For Models

 - [AddPartitionSpecUpdate](docs/AddPartitionSpecUpdate.md)
 - [AddSchemaUpdate](docs/AddSchemaUpdate.md)
 - [AddSnapshotUpdate](docs/AddSnapshotUpdate.md)
 - [AddSortOrderUpdate](docs/AddSortOrderUpdate.md)
 - [AddViewVersionUpdate](docs/AddViewVersionUpdate.md)
 - [AndOrExpression](docs/AndOrExpression.md)
 - [AssertCreate](docs/AssertCreate.md)
 - [AssertCurrentSchemaId](docs/AssertCurrentSchemaId.md)
 - [AssertDefaultSortOrderId](docs/AssertDefaultSortOrderId.md)
 - [AssertDefaultSpecId](docs/AssertDefaultSpecId.md)
 - [AssertLastAssignedFieldId](docs/AssertLastAssignedFieldId.md)
 - [AssertLastAssignedPartitionId](docs/AssertLastAssignedPartitionId.md)
 - [AssertRefSnapshotId](docs/AssertRefSnapshotId.md)
 - [AssertTableUUID](docs/AssertTableUUID.md)
 - [AssertViewUUID](docs/AssertViewUUID.md)
 - [AssignUUIDUpdate](docs/AssignUUIDUpdate.md)
 - [BaseUpdate](docs/BaseUpdate.md)
 - [BlobMetadata](docs/BlobMetadata.md)
 - [CatalogConfig](docs/CatalogConfig.md)
 - [CommitReport](docs/CommitReport.md)
 - [CommitTableRequest](docs/CommitTableRequest.md)
 - [CommitTableResponse](docs/CommitTableResponse.md)
 - [CommitTransactionRequest](docs/CommitTransactionRequest.md)
 - [CommitViewRequest](docs/CommitViewRequest.md)
 - [ContentFile](docs/ContentFile.md)
 - [CountMap](docs/CountMap.md)
 - [CounterResult](docs/CounterResult.md)
 - [CreateNamespaceRequest](docs/CreateNamespaceRequest.md)
 - [CreateNamespaceResponse](docs/CreateNamespaceResponse.md)
 - [CreateTableRequest](docs/CreateTableRequest.md)
 - [CreateViewRequest](docs/CreateViewRequest.md)
 - [DataFile](docs/DataFile.md)
 - [EqualityDeleteFile](docs/EqualityDeleteFile.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [Expression](docs/Expression.md)
 - [FileFormat](docs/FileFormat.md)
 - [GetNamespaceResponse](docs/GetNamespaceResponse.md)
 - [IcebergErrorResponse](docs/IcebergErrorResponse.md)
 - [ListNamespacesResponse](docs/ListNamespacesResponse.md)
 - [ListTablesResponse](docs/ListTablesResponse.md)
 - [ListType](docs/ListType.md)
 - [LiteralExpression](docs/LiteralExpression.md)
 - [LoadTableResult](docs/LoadTableResult.md)
 - [LoadViewResult](docs/LoadViewResult.md)
 - [MapType](docs/MapType.md)
 - [MetadataLogInner](docs/MetadataLogInner.md)
 - [MetricResult](docs/MetricResult.md)
 - [ModelSchema](docs/ModelSchema.md)
 - [NotExpression](docs/NotExpression.md)
 - [NotificationRequest](docs/NotificationRequest.md)
 - [NotificationType](docs/NotificationType.md)
 - [NullOrder](docs/NullOrder.md)
 - [OAuthError](docs/OAuthError.md)
 - [OAuthTokenResponse](docs/OAuthTokenResponse.md)
 - [PartitionField](docs/PartitionField.md)
 - [PartitionSpec](docs/PartitionSpec.md)
 - [PartitionStatisticsFile](docs/PartitionStatisticsFile.md)
 - [PositionDeleteFile](docs/PositionDeleteFile.md)
 - [PrimitiveTypeValue](docs/PrimitiveTypeValue.md)
 - [RegisterTableRequest](docs/RegisterTableRequest.md)
 - [RemovePartitionStatisticsUpdate](docs/RemovePartitionStatisticsUpdate.md)
 - [RemovePropertiesUpdate](docs/RemovePropertiesUpdate.md)
 - [RemoveSnapshotRefUpdate](docs/RemoveSnapshotRefUpdate.md)
 - [RemoveSnapshotsUpdate](docs/RemoveSnapshotsUpdate.md)
 - [RemoveStatisticsUpdate](docs/RemoveStatisticsUpdate.md)
 - [RenameTableRequest](docs/RenameTableRequest.md)
 - [ReportMetricsRequest](docs/ReportMetricsRequest.md)
 - [SQLViewRepresentation](docs/SQLViewRepresentation.md)
 - [ScanReport](docs/ScanReport.md)
 - [SetCurrentSchemaUpdate](docs/SetCurrentSchemaUpdate.md)
 - [SetCurrentViewVersionUpdate](docs/SetCurrentViewVersionUpdate.md)
 - [SetDefaultSortOrderUpdate](docs/SetDefaultSortOrderUpdate.md)
 - [SetDefaultSpecUpdate](docs/SetDefaultSpecUpdate.md)
 - [SetExpression](docs/SetExpression.md)
 - [SetLocationUpdate](docs/SetLocationUpdate.md)
 - [SetPartitionStatisticsUpdate](docs/SetPartitionStatisticsUpdate.md)
 - [SetPropertiesUpdate](docs/SetPropertiesUpdate.md)
 - [SetSnapshotRefUpdate](docs/SetSnapshotRefUpdate.md)
 - [SetStatisticsUpdate](docs/SetStatisticsUpdate.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotLogInner](docs/SnapshotLogInner.md)
 - [SnapshotReference](docs/SnapshotReference.md)
 - [SnapshotSummary](docs/SnapshotSummary.md)
 - [SortDirection](docs/SortDirection.md)
 - [SortField](docs/SortField.md)
 - [SortOrder](docs/SortOrder.md)
 - [StatisticsFile](docs/StatisticsFile.md)
 - [StructField](docs/StructField.md)
 - [StructType](docs/StructType.md)
 - [TableIdentifier](docs/TableIdentifier.md)
 - [TableMetadata](docs/TableMetadata.md)
 - [TableRequirement](docs/TableRequirement.md)
 - [TableUpdate](docs/TableUpdate.md)
 - [TableUpdateNotification](docs/TableUpdateNotification.md)
 - [Term](docs/Term.md)
 - [TimerResult](docs/TimerResult.md)
 - [TokenType](docs/TokenType.md)
 - [TransformTerm](docs/TransformTerm.md)
 - [Type](docs/Type.md)
 - [UnaryExpression](docs/UnaryExpression.md)
 - [UpdateNamespacePropertiesRequest](docs/UpdateNamespacePropertiesRequest.md)
 - [UpdateNamespacePropertiesResponse](docs/UpdateNamespacePropertiesResponse.md)
 - [UpgradeFormatVersionUpdate](docs/UpgradeFormatVersionUpdate.md)
 - [ValueMap](docs/ValueMap.md)
 - [ViewHistoryEntry](docs/ViewHistoryEntry.md)
 - [ViewMetadata](docs/ViewMetadata.md)
 - [ViewRepresentation](docs/ViewRepresentation.md)
 - [ViewRequirement](docs/ViewRequirement.md)
 - [ViewUpdate](docs/ViewUpdate.md)
 - [ViewVersion](docs/ViewVersion.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **catalog**: Allows interacting with the Config and Catalog APIs

<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




