/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.remote.ChannelDecorator;
import org.apache.skywalking.apm.dependencies.io.grpc.CallOptions;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientCall;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientInterceptor;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientInterceptors;
import org.apache.skywalking.apm.dependencies.io.grpc.ForwardingClientCall;
import org.apache.skywalking.apm.dependencies.io.grpc.Metadata;
import org.apache.skywalking.apm.dependencies.io.grpc.MethodDescriptor;
import org.apache.skywalking.apm.util.StringUtil;

public class AuthenticationDecorator
implements ChannelDecorator {
    private static final Metadata.Key<String> AUTH_HEAD_HEADER_NAME = Metadata.Key.of("Authentication", Metadata.ASCII_STRING_MARSHALLER);

    @Override
    public Channel build(Channel channel) {
        if (StringUtil.isEmpty(Config.Agent.AUTHENTICATION)) {
            return channel;
        }
        return ClientInterceptors.intercept(channel, new ClientInterceptor(){

            public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> method, CallOptions options, Channel channel) {
                return new ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP>(channel.newCall(method, options)){

                    @Override
                    public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
                        headers.put(AUTH_HEAD_HEADER_NAME, Config.Agent.AUTHENTICATION);
                        super.start(responseListener, headers);
                    }
                };
            }
        });
    }
}

