/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.tsfile.read.common.block.TsBlock;

public class DescBinaryTypeJoinKeyComparator
implements JoinKeyComparator {
    private static final DescBinaryTypeJoinKeyComparator INSTANCE = new DescBinaryTypeJoinKeyComparator();

    private DescBinaryTypeJoinKeyComparator() {
    }

    public static DescBinaryTypeJoinKeyComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<Boolean> lessThan(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getBinary(leftRowIndex).compareTo(right.getColumn(rightColumnIndex).getBinary(rightRowIndex)) > 0);
    }

    @Override
    public Optional<Boolean> equalsTo(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getBinary(leftRowIndex).equals((Object)right.getColumn(rightColumnIndex).getBinary(rightRowIndex)));
    }

    @Override
    public Optional<Boolean> lessThanOrEqual(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getBinary(leftRowIndex).compareTo(right.getColumn(rightColumnIndex).getBinary(rightRowIndex)) >= 0);
    }
}

