/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;

public class CoshColumnTransformer
extends UnaryColumnTransformer {
    public CoshColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, int i) {
        if (TSDataType.DOUBLE.equals((Object)column.getDataType())) {
            columnBuilder.writeDouble(Math.cosh(column.getDouble(i)));
        } else if (TSDataType.FLOAT.equals((Object)column.getDataType())) {
            columnBuilder.writeDouble(Math.cosh(column.getFloat(i)));
        } else if (TSDataType.INT32.equals((Object)column.getDataType())) {
            columnBuilder.writeDouble(Math.cosh(column.getInt(i)));
        } else if (TSDataType.INT64.equals((Object)column.getDataType())) {
            columnBuilder.writeDouble(Math.cosh(column.getLong(i)));
        }
    }
}

