/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class CustomIndexRelation
implements Relation {
    private final CqlIdentifier indexId;
    private final Term expression;

    public CustomIndexRelation(@NonNull CqlIdentifier indexId, @NonNull Term expression) {
        this.indexId = indexId;
        this.expression = expression;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append("expr(").append(this.indexId.asCql(true)).append(',');
        this.expression.appendTo(builder);
        builder.append(')');
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @NonNull
    public CqlIdentifier getIndexId() {
        return this.indexId;
    }

    @NonNull
    public Term getExpression() {
        return this.expression;
    }
}

