/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.security.Provider;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class KeyStoreKeyManagerProperties
implements Serializable {
    private static final long serialVersionUID = -115811521330361189L;
    private boolean allowNonFIPSInFIPSMode;
    private boolean validateKeyStore;
    @Nullable
    private char[] keyStorePIN;
    @Nullable
    private Provider provider;
    @Nullable
    private String certificateAlias;
    @NotNull
    private String keyStorePath;
    @Nullable
    private String keyStoreFormat;

    public KeyStoreKeyManagerProperties(@NotNull File keyStoreFile) {
        this(keyStoreFile.getAbsolutePath());
    }

    public KeyStoreKeyManagerProperties(@NotNull String keyStorePath) {
        Validator.ensureNotNull(keyStorePath);
        this.keyStorePath = keyStorePath;
        this.keyStorePIN = null;
        this.keyStoreFormat = null;
        this.certificateAlias = null;
        this.provider = null;
        this.validateKeyStore = false;
        this.allowNonFIPSInFIPSMode = false;
    }

    @NotNull
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStoreFile(@NotNull File keyStoreFile) {
        Validator.ensureNotNull(keyStoreFile);
        this.keyStorePath = keyStoreFile.getAbsolutePath();
    }

    public void setKeyStorePath(@NotNull String keyStorePath) {
        Validator.ensureNotNull(keyStorePath);
        this.keyStorePath = keyStorePath;
    }

    @Nullable
    public char[] getKeyStorePIN() {
        return this.keyStorePIN;
    }

    public void setKeyStorePIN(@Nullable char[] keyStorePIN) {
        this.keyStorePIN = keyStorePIN;
    }

    public void setKeyStorePIN(@Nullable String keyStorePIN) {
        this.keyStorePIN = (char[])(keyStorePIN == null ? null : keyStorePIN.toCharArray());
    }

    @Nullable
    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(@Nullable String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    @Nullable
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(@Nullable String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public boolean validateKeyStore() {
        return this.validateKeyStore;
    }

    public void setValidateKeyStore(boolean validateKeyStore) {
        this.validateKeyStore = validateKeyStore;
    }

    @Nullable
    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(@Nullable Provider provider) {
        this.provider = provider;
    }

    public boolean allowNonFIPSInFIPSMode() {
        return this.allowNonFIPSInFIPSMode;
    }

    public void setAllowNonFIPSInFIPSMode(boolean allowNonFIPSInFIPSMode) {
        this.allowNonFIPSInFIPSMode = allowNonFIPSInFIPSMode;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("KeyStoreKeyManagerProperties(keyStorePath='");
        buffer.append(this.keyStorePath);
        buffer.append('\'');
        buffer.append(", keyStorePINProvided=");
        buffer.append(this.keyStorePIN != null);
        if (this.keyStoreFormat != null) {
            buffer.append(", keyStoreFormat='");
            buffer.append(this.keyStoreFormat);
            buffer.append('\'');
        }
        if (this.certificateAlias != null) {
            buffer.append(", certificateAlias='");
            buffer.append(this.certificateAlias);
            buffer.append('\'');
        }
        buffer.append(", validateKeyStore=");
        buffer.append(this.validateKeyStore);
        if (this.provider != null) {
            buffer.append(", providerClass='");
            buffer.append(this.provider.getClass().getName());
            buffer.append('\'');
        }
        buffer.append(", allowNonFIPSInFIPSMode=");
        buffer.append(this.allowNonFIPSInFIPSMode);
        buffer.append(')');
    }
}

