/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;

class RegisterConfigurationCommand
implements Command {
    private final CassandraMailQueueViewConfiguration configuration;
    private final AggregateId aggregateId;

    RegisterConfigurationCommand(CassandraMailQueueViewConfiguration configuration, AggregateId aggregateId) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)aggregateId);
        this.aggregateId = aggregateId;
        this.configuration = configuration;
    }

    CassandraMailQueueViewConfiguration getConfiguration() {
        return this.configuration;
    }

    public final boolean equals(Object o) {
        if (o instanceof RegisterConfigurationCommand) {
            RegisterConfigurationCommand that = (RegisterConfigurationCommand)o;
            return Objects.equals(this.configuration, that.configuration) && Objects.equals(this.aggregateId, that.aggregateId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.configuration, this.aggregateId);
    }

    public AggregateId getAggregateId() {
        return this.aggregateId;
    }
}

