/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

final class ResponseWarningsExtractor {
    private static final Pattern WARNING_HEADER_DATE_PATTERN = Pattern.compile("^ \"(?>Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?>Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\"$");
    private static final int WARNING_HEADER_DATE_LENGTH = 32;

    private ResponseWarningsExtractor() {
    }

    static List<String> getWarnings(HttpResponse response) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (Header header : response.getHeaders("Warning")) {
            String warning = header.getValue();
            if (ResponseWarningsExtractor.matchWarningHeaderPatternByPrefix(warning)) {
                warnings.add(ResponseWarningsExtractor.extractWarningValueFromWarningHeader(warning));
                continue;
            }
            warnings.add(warning);
        }
        return warnings;
    }

    private static boolean matchWarningHeaderPatternByPrefix(String s) {
        return s.startsWith("299 OpenSearch-");
    }

    private static String extractWarningValueFromWarningHeader(String s) {
        String possibleDateString;
        Matcher matcher;
        String warningHeader = s;
        if (s.length() > 32 && (matcher = WARNING_HEADER_DATE_PATTERN.matcher(possibleDateString = s.substring(s.length() - 32))).matches()) {
            warningHeader = warningHeader.substring(0, s.length() - 32);
        }
        int firstQuote = warningHeader.indexOf(34);
        int lastQuote = warningHeader.length() - 1;
        String warningValue = warningHeader.substring(firstQuote + 1, lastQuote);
        return warningValue;
    }
}

