/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.change.TypeState;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.PushState;
import org.apache.james.jmap.core.PushState$;
import org.apache.james.jmap.core.RequestId;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.core.WebSocketError;
import org.apache.james.jmap.core.WebSocketInboundMessage;
import org.apache.james.jmap.core.WebSocketPushDisable$;
import org.apache.james.jmap.core.WebSocketPushEnable;
import org.apache.james.jmap.core.WebSocketRequest;
import org.apache.james.jmap.core.WebSocketResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.WebSocketRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Scheduler;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0015s!\u0002\u0015*\u0011\u0003!d!\u0002\u001c*\u0011\u00039\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002!\u0002\u0005\u0004%\t!\u0011\u0005\u0007\u0011\u0006\u0001\u000b\u0011\u0002\"\u0007\tYJ\u0003!\u0013\u0005\t?\u0016\u0011)\u0019!C\u0001A\"Aq-\u0002B\u0001B\u0003%\u0011\r\u0003\u0005i\u000b\t\u0015\r\u0011\"\u0001j\u0011!yWA!A!\u0002\u0013Q\u0007\u0002\u00039\u0006\u0005\u0003\u0005\u000b\u0011B9\t\u0011Q,!\u0011!Q\u0001\nUD!\"a\u0004\u0006\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\t9\"\u0002B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003S)!\u0011!Q\u0001\n\u0005-\u0002BCA\u0019\u000b\t\u0005\t\u0015!\u0003\u00024!Q\u0011qH\u0003\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005\u001dSA!A!\u0002\u0013\tI\u0005\u0003\u0006\u0002X\u0015\u0011\t\u0011)A\u0005\u00033BaAP\u0003\u0005\u0002\u0005\u001d\u0004\"CAI\u000b\t\u0007I\u0011BAJ\u0011!\tY*\u0002Q\u0001\n\u0005U\u0005\"CAO\u000b\t\u0007I\u0011BAJ\u0011!\ty*\u0002Q\u0001\n\u0005U\u0005\"CAQ\u000b\t\u0007I\u0011BAR\u0011!\tY,\u0002Q\u0001\n\u0005\u0015\u0006\"CA_\u000b\t\u0007I\u0011BA`\u0011!\t9.\u0002Q\u0001\n\u0005\u0005\u0007B\u0002\u0016\u0006\t\u0003\nI\u000eC\u0004\u0002n\u0016!I!a<\t\u000f\teQ\u0001\"\u0003\u0003\u001c!9!\u0011J\u0003\u0005\n\t-\u0003b\u0002BC\u000b\u0011%!q\u0011\u0005\b\u0005k+A\u0011\u0002B\\\u0011\u001d\u0011)-\u0002C\u0005\u0005\u000fDqAa3\u0006\t\u0013\u0011i\rC\u0004\u0003l\u0016!IA!<\t\u000f\r%Q\u0001\"\u0003\u0004\f!91\u0011D\u0003\u0005B\rm\u0001bBB\u001d\u000b\u0011\u000531H\u0001\u0010/\u0016\u00147k\\2lKR\u0014v.\u001e;fg*\u0011!fK\u0001\u0007e>,H/Z:\u000b\u00051j\u0013\u0001\u00026nCBT!AL\u0018\u0002\u000b)\fW.Z:\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001!\t)\u0014!D\u0001*\u0005=9VMY*pG.,GOU8vi\u0016\u001c8CA\u00019!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001N\u0001\u0007\u0019>;u)\u0012*\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\u0019\u0002\u000bMdg\r\u000e6\n\u0005\u001d#%A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0014\u000b\u0015Q%K\u0016/\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001\u00027b]\u001eT\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0019\n1qJ\u00196fGR\u0004\"a\u0015+\u000e\u0003-J!!V\u0016\u0003\u0015)k\u0015\t\u0015*pkR,7\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Z[\u0005!1m\u001c:f\u0013\tY\u0006L\u0001\u0007ESN\u001cwN\u001c8fGR|'\u000f\u0005\u0002X;&\u0011a\f\u0017\u0002\u001e\u0007>tg.Z2uS>tG)Z:de&\u0004H/[8o'V\u0004\b\u000f\\5fe\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I.\nA\u0001\u001b;ua&\u0011am\u0019\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005i1m\u001c8gS\u001e,(/\u0019;j_:,\u0012A\u001b\t\u0003W6l\u0011\u0001\u001c\u0006\u00033.J!A\u001c7\u00031)k\u0017\r\u001d*gGb2$'M\"p]\u001aLw-\u001e:bi&|g.\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011\u0002\u001fU\u001cXM\u001d)s_ZL7/[8oKJ\u0004\"A\u0019:\n\u0005M\u001c'\u0001E+tKJ\u0004&o\u001c<jg&|g.\u001b8h\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001<z\u001b\u00059(B\u0001=.\u0003\u0019)g/\u001a8ug&\u0011!p\u001e\u0002\t\u000bZ,g\u000e\u001e\"vg\"21\u0002`A\u0005\u0003\u0017\u00012!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u00051\u0011N\u001c6fGRT!!a\u0001\u0002\u000f)\f7.\u0019:uC&\u0019\u0011q\u0001@\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0005\u00055\u0011\u0001\u0002&N\u0003B\u000bqA[7ba\u0006\u0003\u0018\u000eE\u00026\u0003'I1!!\u0006*\u0005\u001dQU*\u0011)Ba&\fq#\\1jY\n|\u0007p\u00115b]\u001e,'+\u001a9pg&$xN]=\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u000511\r[1oO\u0016T1!a\t,\u0003\r\t\u0007/[\u0005\u0005\u0003O\tiBA\fNC&d'm\u001c=DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ss\u0006)R-\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\b\u0003BA\u000e\u0003[IA!a\f\u0002\u001e\t)R)\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018A\u00049vg\"\u001cVM]5bY&TXM\u001d\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H\u0016\u0002\t)\u001cxN\\\u0005\u0005\u0003{\t9D\u0001\bQkND7+\u001a:jC2L'0\u001a:\u0002!QL\b/Z*uCR,g)Y2u_JL\b\u0003BA\u000e\u0003\u0007JA!!\u0012\u0002\u001e\t\u0001B+\u001f9f'R\fG/\u001a$bGR|'/_\u0001\u0010I\u0016dWmZ1uS>t7\u000b^8sKB!\u00111JA*\u001b\t\tiE\u0003\u0003\u0002$\u0005=#bAA)[\u0005!Qo]3s\u0013\u0011\t)&!\u0014\u0003\u001f\u0011+G.Z4bi&|gn\u0015;pe\u0016\fQ\"\\3ue&\u001cg)Y2u_JL\b\u0003BA.\u0003Gj!!!\u0018\u000b\t\u0005\r\u0012q\f\u0006\u0004\u0003Cj\u0013aB7fiJL7m]\u0005\u0005\u0003K\niFA\u0007NKR\u0014\u0018n\u0019$bGR|'/\u001f\u000b\u0019\u0003S\nY'a\u001d\u0002v\u0005]\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0005CA\u001b\u0006\u0011\u0015y6\u00031\u0001bQ\u001d\tY\u0007`A\u0005\u0003_\n#!!\u001d\u0002\u0011I35)\f\u001d7eEBQ\u0001[\nA\u0002)DQ\u0001]\nA\u0002EDQ\u0001^\nA\u0002UDs!a\u001e}\u0003\u0013\tY\u0001C\u0004\u0002\u0010M\u0001\r!!\u0005\t\u000f\u0005]1\u00031\u0001\u0002\u001a!9\u0011\u0011F\nA\u0002\u0005-\u0002bBA\u0019'\u0001\u0007\u00111\u0007\u0005\b\u0003\u007f\u0019\u0002\u0019AA!\u0011\u001d\t9e\u0005a\u0001\u0003\u0013Bq!a\u0016\u0014\u0001\u0004\tI\u0006K\u0002\u0014\u0003\u0017\u00032!`AG\u0013\r\tyI \u0002\u0007\u0013:TWm\u0019;\u00021=\u0004XM\\5oO\u000e{gN\\3di&|gn]'fiJL7-\u0006\u0002\u0002\u0016B!\u00111LAL\u0013\u0011\tI*!\u0018\u0003\r5+GO]5d\u0003ey\u0007/\u001a8j]\u001e\u001cuN\u001c8fGRLwN\\:NKR\u0014\u0018n\u0019\u0011\u0002%I,\u0017/^3ti\u000e{WO\u001c;NKR\u0014\u0018nY\u0001\u0014e\u0016\fX/Z:u\u0007>,h\u000e^'fiJL7\rI\u0001\u000fG>tg.Z2uK\u0012,6/\u001a:t+\t\t)\u000b\u0005\u0005\u0002(\u0006E\u0016QWA[\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016AC2p]\u000e,(O]3oi*\u0019\u0011q\u0016(\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\u000bIKA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042!NA\\\u0013\r\tI,\u000b\u0002\u000e\u00072LWM\u001c;D_:$X\r\u001f;\u0002\u001f\r|gN\\3di\u0016$Wk]3sg\u0002\n1c^3cg>\u001c7.\u001a;TKJ4XM]*qK\u000e,\"!!1\u0011\t\u0005\r\u00171[\u0007\u0003\u0003\u000bTA!a2\u0002J\u000611/\u001a:wKJT1\u0001ZAf\u0015\u0011\ti-a4\u0002\u000b9,G\u000f^=\u000b\u0005\u0005E\u0017a\u0002:fC\u000e$xN]\u0005\u0005\u0003+\f)MA\nXK\n\u001cxnY6fiN+'O^3s'B,7-\u0001\u000bxK\n\u001cxnY6fiN+'O^3s'B,7\r\t\u000b\u0003\u00037\u0004b!!8\u0002d\u0006\u001dXBAAp\u0015\u0011\t\t/!,\u0002\rM$(/Z1n\u0013\u0011\t)/a8\u0003\rM#(/Z1n!\r\u0019\u0016\u0011^\u0005\u0004\u0003W\\#!\u0003&N\u0003B\u0013v.\u001e;f\u0003AA\u0017M\u001c3mK^+'mU8dW\u0016$8\u000f\u0006\u0004\u0002r\n\u0015!q\u0002\t\u0007\u0003g\fY0a@\u000e\u0005\u0005U(\u0002BA|\u0003s\f\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007e\u000by-\u0003\u0003\u0002~\u0006U(\u0001B'p]>\u00042a\u0013B\u0001\u0013\r\u0011\u0019\u0001\u0014\u0002\u0005->LG\rC\u0004\u0003\bu\u0001\rA!\u0003\u0002#!$H\u000f]*feZ,'OU3rk\u0016\u001cH\u000f\u0005\u0003\u0002D\n-\u0011\u0002\u0002B\u0007\u0003\u000b\u0014\u0011\u0003\u0013;uaN+'O^3s%\u0016\fX/Z:u\u0011\u001d\u0011\t\"\ba\u0001\u0005'\t!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tKB!\u00111\u0019B\u000b\u0013\u0011\u00119\"!2\u0003%!#H\u000f]*feZ,'OU3ta>t7/Z\u0001\u001aQ\u0006tG\r\\3XK\n\u001cvnY6fi\u000e{gN\\3di&|g\u000e\u0006\u0003\u0003\u001e\teBCBAy\u0005?\u0011y\u0003C\u0004\u0003\"y\u0001\rAa\t\u0002\u0005%t\u0007\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\t\t%\u0012\u0011Z\u0001\no\u0016\u00147o\\2lKRLAA!\f\u0003(\t\u0001r+\u001a2t_\u000e\\W\r^%oE>,h\u000e\u001a\u0005\b\u0005cq\u0002\u0019\u0001B\u001a\u0003\ryW\u000f\u001e\t\u0005\u0005K\u0011)$\u0003\u0003\u00038\t\u001d\"!E,fEN|7m[3u\u001fV$(m\\;oI\"9!1\b\u0010A\u0002\tu\u0012aB:fgNLwN\u001c\t\u0005\u0005\u007f\u0011)%\u0004\u0002\u0003B)\u0019!1I\u0017\u0002\u000f5\f\u0017\u000e\u001c2pq&!!q\tB!\u00059i\u0015-\u001b7c_b\u001cVm]:j_:\fA\u0003]5oO6+7o]1hKB+(\r\\5tQ\u0016\u0014H\u0003\u0002B'\u0005k\u0002bAa\u0014\u0003V\teSB\u0001B)\u0015\u0011\t9Pa\u0015\u000b\u0007m\nI0\u0003\u0003\u0003X\tE#!B*GYVD\b\u0003\u0002B.\u0005cj!A!\u0018\u000b\t\t}#\u0011M\u0001\u000bo\u0016\u00147o\\2lKRD(b\u00013\u0003d)!!Q\rB4\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011IGa\u001b\u0002\u000f!\fg\u000e\u001a7fe*!\u0011Q\u001aB7\u0015\t\u0011y'\u0001\u0002j_&!!1\u000fB/\u000599VMY*pG.,GO\u0012:b[\u0016DqAa\u001e \u0001\u0004\u0011I(\u0001\u0005ekJ\fG/[8o!\u0011\u0011YH!!\u000e\u0005\tu$\u0002\u0002B<\u0005\u007fR1!a+;\u0013\u0011\u0011\u0019I! \u0003\u0011\u0011+(/\u0019;j_:\fA\u0003[1oI2,7\t\\5f]RlUm]:bO\u0016\u001cH\u0003\u0002BE\u0005c#BAa#\u0003\u0018B1!q\nBG\u0005#KAAa$\u0003R\t)1+T8o_B\u00191Na%\n\u0007\tUENA\bPkR\u0014w.\u001e8e\u001b\u0016\u001c8/Y4f\u0011\u001d\u0011I\n\ta\u0001\u00057\u000bq!\\3tg\u0006<W\r\u0005\u0003\u0003\u001e\n-f\u0002\u0002BP\u0005O\u00032A!);\u001b\t\u0011\u0019KC\u0002\u0003&N\na\u0001\u0010:p_Rt\u0014b\u0001BUu\u00051\u0001K]3eK\u001aLAA!,\u00030\n11\u000b\u001e:j]\u001eT1A!+;\u0011\u001d\u0011\u0019\f\ta\u0001\u0003k\u000bQb\u00197jK:$8i\u001c8uKb$\u0018\u0001G:f]\u0012\u0004Vo\u001d5Ti\u0006$X-\u00134SKF,Xm\u001d;fIR1!1\u0012B]\u0005\u0007DqAa/\"\u0001\u0004\u0011i,\u0001\u0006qkNDWI\\1cY\u0016\u00042a\u001bB`\u0013\r\u0011\t\r\u001c\u0002\u0014/\u0016\u00147k\\2lKR\u0004Vo\u001d5F]\u0006\u0014G.\u001a\u0005\b\u0005g\u000b\u0003\u0019AA[\u00035\u0019XM\u001c3QkND7\u000b^1uKR!!1\u0012Be\u0011\u001d\u0011\u0019L\ta\u0001\u0003k\u000b\u0001\u0004[1oI2,\u0007\n\u001e;q\u0011\u0006tGm\u001d5bW\u0016,%O]8s)\u0019\u0011yM!5\u0003hB1!q\nBG\u0003\u007fDqAa5$\u0001\u0004\u0011).A\u0005uQJ|w/\u00192mKB!!q\u001bBq\u001d\u0011\u0011IN!8\u000f\t\t\u0005&1\\\u0005\u0002w%\u0019!q\u001c\u001e\u0002\u000fA\f7m[1hK&!!1\u001dBs\u0005%!\u0006N]8xC\ndWMC\u0002\u0003`jBqA!;$\u0001\u0004\u0011\u0019\"\u0001\u0005sKN\u0004xN\\:f\u0003\u001d\t7/\u0012:s_J$BAa<\u0003zR!!\u0011\u001fB|!\rY'1_\u0005\u0004\u0005kd'AD,fEN{7m[3u\u000bJ\u0014xN\u001d\u0005\b\u0005'$\u0003\u0019\u0001Bk\u0011\u001d\u0011Y\u0010\na\u0001\u0005{\f\u0011B]3rk\u0016\u001cH/\u00133\u0011\u000be\u0012ypa\u0001\n\u0007\r\u0005!H\u0001\u0004PaRLwN\u001c\t\u0004W\u000e\u0015\u0011bAB\u0004Y\nI!+Z9vKN$\u0018\nZ\u0001\u000fe\u0016\u001c\bo\u001c8e\t\u0016$\u0018-\u001b7t)\u0019\u0011ym!\u0004\u0004\u0010!9!\u0011C\u0013A\u0002\tM\u0001bBB\tK\u0001\u000711C\u0001\bI\u0016$\u0018-\u001b7t!\rY7QC\u0005\u0004\u0007/a'A\u0004)s_\ndW-\u001c#fi\u0006LGn]\u0001\u000bI&\u001c8m\u001c8oK\u000e$H\u0003BB\u000f\u0007G\u00012!OB\u0010\u0013\r\u0019\tC\u000f\u0002\u0005+:LG\u000fC\u0004\u0004&\u0019\u0002\raa\n\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004ba!\u000b\u00040\rMRBAB\u0016\u0015\u0011\u0019i#!,\u0002\u0011\u0019,hn\u0019;j_:LAa!\r\u0004,\tI\u0001K]3eS\u000e\fG/\u001a\t\u0004/\u000eU\u0012bAB\u001c1\nAQk]3s]\u0006lW-A\neKN\u001c'/\u001b2f\u0007>tg.Z2uS>t7\u000f\u0006\u0002\u0004>A1\u0011Q\\Ar\u0007\u007f\u00012aVB!\u0013\r\u0019\u0019\u0005\u0017\u0002\u0016\u0007>tg.Z2uS>tG)Z:de&\u0004H/[8o\u0001")
public class WebSocketRoutes
implements JMAPRoutes,
Disconnector,
ConnectionDescriptionSupplier {
    private final Authenticator authenticator;
    private final JmapRfc8621Configuration configuration;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final JMAPApi jmapApi;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;
    private final Metric openingConnectionsMetric;
    private final Metric requestCountMetric;
    private final ConcurrentHashMap<ClientContext, ClientContext> connectedUsers;
    private final WebsocketServerSpec websocketServerSpec;

    public static Logger LOGGER() {
        return WebSocketRoutes$.MODULE$.LOGGER();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    private Metric openingConnectionsMetric() {
        return this.openingConnectionsMetric;
    }

    private Metric requestCountMetric() {
        return this.requestCountMetric;
    }

    private ConcurrentHashMap<ClientContext, ClientContext> connectedUsers() {
        return this.connectedUsers;
    }

    private WebsocketServerSpec websocketServerSpec() {
        return this.websocketServerSpec;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)"/jmap/ws")).action((httpServerRequest, httpServerResponse) -> this.handleWebSockets(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap/ws")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleWebSockets(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(SMono$.MODULE$.apply((Publisher)httpServerResponse.addHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (CharSequence)"jmap").sendWebsocket((in, out) -> this.handleWebSocketConnection((MailboxSession)mailboxSession, (WebsocketInbound)in, (WebsocketOutbound)out), this.websocketServerSpec())))).onErrorResume((Function1 & Serializable)throwable -> this.handleHttpHandshakeError((Throwable)throwable, httpServerResponse)).asJava().then();
    }

    private Mono<Void> handleWebSocketConnection(MailboxSession session, WebsocketInbound in, WebsocketOutbound out) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        this.openingConnectionsMetric().increment();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux qual$1 = SFlux$.MODULE$.apply((Publisher)in.aggregateFrames().receiveFrames()).filter((Function1 & Serializable)frame -> BoxesRunTime.boxToBoolean((boolean)WebSocketRoutes.$anonfun$handleWebSocketConnection$1(frame))).map((Function1 & Serializable)frame -> ((TextWebSocketFrame)frame).text()).doOnNext((Function1 & Serializable)x$1 -> {
            WebSocketRoutes.$anonfun$handleWebSocketConnection$3(this, context, x$1);
            return BoxedUnit.UNIT;
        }).doOnNext((Function1 & Serializable)x$2 -> {
            WebSocketRoutes.$anonfun$handleWebSocketConnection$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$12 = (Function1 & Serializable)message -> this.handleClientMessages(context, (String)message);
        int x$22 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SFlux responseFlux = qual$1.flatMap((Function1)x$12, x$22, x$3, x$4).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            context.clean();
            this.connectedUsers().remove(context);
            this.openingConnectionsMetric().decrement();
        }).doOnCancel((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            context.clean();
            this.connectedUsers().remove(context);
            this.openingConnectionsMetric().decrement();
        });
        SFlux responseAndSinkFlux = SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)responseFlux, (List)new .colon.colon((Object)sink.asFlux(), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).map((Function1 & Serializable)outboundMessage -> $this.pushSerializer.serialize((OutboundMessage)outboundMessage)).map((Function1 & Serializable)json -> new TextWebSocketFrame(Json$.MODULE$.stringify(json)));
        SFlux resultFlux = (SFlux)this.configuration().websocketPingInterval().map((Function1 & Serializable)interval -> responseAndSinkFlux.mergeWith(this.pingMessagePublisher((Duration)interval))).getOrElse((Function0 & Serializable)() -> responseAndSinkFlux);
        return out.sendObject((Publisher)resultFlux).then();
    }

    private SFlux<WebSocketFrame> pingMessagePublisher(Duration duration) {
        Duration x$1 = duration;
        Scheduler x$2 = SFlux$.MODULE$.interval$default$2();
        Duration x$32 = SFlux$.MODULE$.interval$default$3(x$1, x$2);
        return SFlux$.MODULE$.interval(x$1, x$2, x$32).map((Function1 & Serializable)x$3 -> WebSocketRoutes.$anonfun$pingMessagePublisher$1(BoxesRunTime.unboxToLong((Object)x$3)));
    }

    private SMono<OutboundMessage> handleClientMessages(ClientContext clientContext, String message) {
        return (SMono)this.pushSerializer.deserializeWebSocketInboundMessage(message).fold((Function1 & Serializable)invalid -> {
            WebSocketError error = this.asError((Option<RequestId>)None$.MODULE$, new IllegalArgumentException(invalid.toString()));
            return SMono$.MODULE$.just((Object)error);
        }, (Function1 & Serializable)x0$1 -> {
            WebSocketInboundMessage webSocketInboundMessage = x0$1;
            if (webSocketInboundMessage instanceof WebSocketRequest) {
                WebSocketRequest webSocketRequest = (WebSocketRequest)webSocketInboundMessage;
                return $this.jmapApi.process(webSocketRequest.requestObject(), clientContext.session()).map((Function1 & Serializable)x$4 -> new WebSocketResponse(webSocketRequest.id(), (ResponseObject)x$4)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)this.asError(webSocketRequest.id(), (Throwable)e)));
            }
            if (webSocketInboundMessage instanceof WebSocketPushEnable) {
                WebSocketPushEnable webSocketPushEnable = (WebSocketPushEnable)webSocketInboundMessage;
                return SMono$.MODULE$.just((Object)clientContext.session().getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher($this.delegationStore.delegatedUsers(clientContext.session().getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener((Set<TypeName>)((Set)webSocketPushEnable.dataTypes().getOrElse((Function0 & Serializable)() -> $this.typeStateFactory.all().toSet())), clientContext.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
                    clientContext.withRegistration(newRegistration);
                    return BoxedUnit.UNIT;
                }).then(this.sendPushStateIfRequested(webSocketPushEnable, clientContext));
            }
            if (WebSocketPushDisable$.MODULE$.equals(webSocketInboundMessage)) {
                return SMono$.MODULE$.fromCallable(() -> {
                    clientContext.clean();
                    return BoxedUnit.UNIT;
                }).then(SMono$.MODULE$.fromCallable(() -> this.connectedUsers().remove(clientContext))).then(SMono$.MODULE$.empty());
            }
            throw new MatchError((Object)webSocketInboundMessage);
        });
    }

    private SMono<OutboundMessage> sendPushStateIfRequested(WebSocketPushEnable pushEnable, ClientContext clientContext) {
        return (SMono)pushEnable.pushState().map((Function1 & Serializable)x$5 -> this.sendPushState(clientContext)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
    }

    private SMono<OutboundMessage> sendPushState(ClientContext clientContext) {
        Username username = clientContext.session().getUser();
        org.apache.james.jmap.core.AccountId accountId = (org.apache.james.jmap.core.AccountId)AccountId$.MODULE$.from(username).fold((Function1 & Serializable)failure -> {
            throw new IllegalArgumentException((Throwable)failure);
        }, (Function1 & Serializable)success -> success);
        return SMono$.MODULE$.apply((Publisher)this.mailboxChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).flatMap(mailboxState -> $this.emailChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).map(emailState -> new StateChange((scala.collection.immutable.Map<org.apache.james.jmap.core.AccountId, TypeState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)accountId), (Object)new TypeState((scala.collection.immutable.Map<TypeName, State>)((scala.collection.immutable.Map)MailboxTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)mailboxState))).$plus$plus(EmailTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)emailState)))))))}))), (Option<PushState>)new Some((Object)PushState$.MODULE$.from(new UuidState(mailboxState.getValue()), new UuidState(emailState.getValue())))))));
    }

    private SMono<Void> handleHttpHandshakeError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private WebSocketError asError(Option<RequestId> requestId, Throwable throwable) {
        return new WebSocketError(requestId, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public void disconnect(Predicate<Username> username) {
        java.util.List<ClientContext> contexts = this.connectedUsers().values().stream().filter(context -> username.test(context.session().getUser())).toList();
        contexts.forEach(context -> {
            context.clean();
            this.connectedUsers().remove(context);
        });
    }

    public Stream<ConnectionDescription> describeConnections() {
        boolean writable = true;
        boolean encrypted = true;
        return this.connectedUsers().values().stream().map(context -> new ConnectionDescription("JMAP", "WebSocket", Optional.empty(), Optional.empty(), context.pushRegistration().get() != null, context.pushRegistration().get() != null, writable, !encrypted, Optional.ofNullable(context.session().getUser()), (Map)ImmutableMap.of()));
    }

    public static final /* synthetic */ boolean $anonfun$handleWebSocketConnection$1(WebSocketFrame frame) {
        return frame instanceof TextWebSocketFrame;
    }

    public static final /* synthetic */ void $anonfun$handleWebSocketConnection$3(WebSocketRoutes $this, ClientContext context$1, String x$1) {
        $this.connectedUsers().put(context$1, context$1);
    }

    public static final /* synthetic */ void $anonfun$handleWebSocketConnection$4(WebSocketRoutes $this, String x$2) {
        $this.requestCountMetric().increment();
    }

    public static final /* synthetic */ PingWebSocketFrame $anonfun$pingMessagePublisher$1(long x$3) {
        return new PingWebSocketFrame();
    }

    @Inject
    public WebSocketRoutes(@Named(value="RFC-8621") Authenticator authenticator, JmapRfc8621Configuration configuration, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, JMAPApi jmapApi, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore, MetricFactory metricFactory) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.jmapApi = jmapApi;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
        this.openingConnectionsMetric = metricFactory.generate("jmap_websocket_opening_connections_count");
        this.requestCountMetric = metricFactory.generate("jmap_websocket_requests_count");
        this.connectedUsers = new ConcurrentHashMap();
        this.websocketServerSpec = ((WebsocketServerSpec.Builder)WebsocketServerSpec.builder().handlePing(false)).build();
    }
}

