/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.DisconnectReason;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage;

public class DisconnectMessage_V3
extends DisconnectMessage {
    private DisconnectReason reason;
    private SimpleString targetNodeID;
    private TransportConfiguration targetConnector;

    public DisconnectMessage_V3(SimpleString nodeID, DisconnectReason reason, SimpleString targetNodeID, TransportConfiguration targetConnector) {
        super((byte)-19);
        this.nodeID = nodeID;
        this.reason = reason;
        this.targetNodeID = targetNodeID;
        this.targetConnector = targetConnector;
    }

    public DisconnectMessage_V3() {
        super((byte)-19);
    }

    public DisconnectReason getReason() {
        return this.reason;
    }

    public SimpleString getTargetNodeID() {
        return this.targetNodeID;
    }

    public TransportConfiguration getTargetConnector() {
        return this.targetConnector;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeByte(this.reason == null ? (byte)-1 : this.reason.getType());
        buffer.writeNullableSimpleString(this.targetNodeID);
        if (this.targetConnector != null) {
            buffer.writeBoolean(true);
            this.targetConnector.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.reason = DisconnectReason.getType((byte)buffer.readByte());
        this.targetNodeID = buffer.readNullableSimpleString();
        boolean hasTargetConnector = buffer.readBoolean();
        if (hasTargetConnector) {
            this.targetConnector = new TransportConfiguration();
            this.targetConnector.decode(buffer);
        } else {
            this.targetConnector = null;
        }
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", nodeID=" + String.valueOf(this.nodeID));
        sb.append(", reason=" + String.valueOf(this.reason));
        sb.append(", targetNodeID=" + String.valueOf(this.targetNodeID));
        sb.append(", targetConnector=" + String.valueOf(this.targetConnector));
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.reason.getType();
        result = 31 * result + (this.targetNodeID == null ? 0 : this.targetNodeID.hashCode());
        result = 31 * result + (this.targetConnector == null ? 0 : this.targetConnector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DisconnectMessage_V3)) {
            return false;
        }
        DisconnectMessage_V3 other = (DisconnectMessage_V3)obj;
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.targetNodeID == null ? other.targetNodeID != null : !this.targetNodeID.equals((Object)other.targetNodeID));
    }
}

