/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import jakarta.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxAnnotationListener
implements EventListener.ReactiveGroupEventListener {
    public static final Group GROUP = new MailboxAnnotationListenerGroup();
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final SessionProvider sessionProvider;

    @Inject
    public MailboxAnnotationListener(MailboxSessionMapperFactory mailboxSessionMapperFactory, SessionProvider sessionProvider) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.sessionProvider = sessionProvider;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxDeletion;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxSession mailboxSession = this.sessionProvider.createSystemSession(event.getUsername());
            AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(mailboxSession);
            MailboxId mailboxId = ((MailboxEvents.MailboxDeletion)event).getMailboxId();
            return Flux.from(annotationMapper.getAllAnnotationsReactive(mailboxId)).flatMap(annotation -> Mono.from(annotationMapper.deleteAnnotationReactive(mailboxId, annotation.getKey()))).then().doFinally(any -> this.mailboxSessionMapperFactory.endProcessingRequest(mailboxSession));
        }
        return Mono.empty();
    }

    public static final class MailboxAnnotationListenerGroup
    extends Group {
    }
}

