/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.model.MessageId;

public class InMemoryMessageId
implements MessageId {
    private final long value;

    public static InMemoryMessageId of(long value) {
        return new InMemoryMessageId(value);
    }

    private InMemoryMessageId(long value) {
        this.value = value;
    }

    public String serialize() {
        return String.valueOf(this.value);
    }

    public long getRawId() {
        return this.value;
    }

    public boolean isSerializable() {
        return true;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public final boolean equals(Object obj) {
        if (obj instanceof InMemoryMessageId) {
            InMemoryMessageId other = (InMemoryMessageId)obj;
            return Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(InMemoryMessageId.class).add("value", this.value).toString();
    }

    public static class Factory
    implements MessageId.Factory {
        private AtomicLong counter = new AtomicLong();

        public MessageId fromString(String serialized) {
            return InMemoryMessageId.of(Long.parseLong(serialized));
        }

        public MessageId generate() {
            return InMemoryMessageId.of(this.counter.incrementAndGet());
        }
    }
}

