/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntNegativePropertyAssertionImpl;
import org.apache.jena.ontapi.impl.objects.OntPropertyImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class OntDataPropertyImpl
extends OntPropertyImpl
implements OntDataProperty {
    public OntDataPropertyImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Class<OntDataProperty> objectType() {
        return OntDataProperty.class;
    }

    @Override
    public Stream<OntDataProperty> superProperties(boolean direct) {
        return OntDataPropertyImpl.superProperties(this, OntDataProperty.class, direct);
    }

    @Override
    public Stream<OntDataProperty> subProperties(boolean direct) {
        return OntDataPropertyImpl.subProperties(this, OntDataProperty.class, direct);
    }

    @Override
    public Stream<OntClass> declaringClasses(boolean direct) {
        return OntDataPropertyImpl.declaringClasses(this, direct);
    }

    @Override
    public boolean hasSuperProperty(OntProperty property, boolean direct) {
        return property.canAs(OntDataProperty.class) && OntPropertyImpl.hasSuperProperty(this, (OntDataProperty)property.as(OntDataProperty.class), OntDataProperty.class, direct);
    }

    @Override
    public Stream<OntDataProperty> disjointProperties() {
        return OntPropertyImpl.disjointProperties(this.getModel(), OntDataProperty.class, this);
    }

    @Override
    public OntStatement addPropertyDisjointWithStatement(OntDataProperty other) {
        return OntPropertyImpl.addDisjointWith(this.getModel(), this, other);
    }

    @Override
    public OntDataProperty removeDisjointProperty(Resource property) {
        OntPropertyImpl.removeDisjointWith(this.getModel(), this, property);
        return this;
    }

    @Override
    public Stream<OntDataProperty> equivalentProperties() {
        return OntPropertyImpl.equivalentProperties(this.getModel(), OntDataProperty.class, this);
    }

    @Override
    public OntStatement addEquivalentPropertyStatement(OntDataProperty other) {
        return OntPropertyImpl.addEquivalentProperty(this.getModel(), this, other);
    }

    @Override
    public OntDataProperty removeEquivalentProperty(Resource property) {
        OntPropertyImpl.removeEquivalentProperty(this.getModel(), this, property);
        return this;
    }

    @Override
    public OntNegativeAssertion.WithDataProperty addNegativeAssertion(OntIndividual source, Literal target) {
        return OntNegativePropertyAssertionImpl.create(this.getModel(), source, this, target);
    }

    @Override
    public boolean isFunctional() {
        return OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_DATA_PROPERTY_FUNCTIONAL_FEATURE) && this.hasType(OWL2.FunctionalProperty);
    }

    @Override
    public OntDataPropertyImpl setFunctional(boolean functional) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_DATA_PROPERTY_FUNCTIONAL_FEATURE, "owl:FunctionalProperty");
        this.changeRDFType(OWL2.FunctionalProperty, functional);
        return this;
    }

    @Override
    public OntStatement addFunctionalDeclaration() {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_DATA_PROPERTY_FUNCTIONAL_FEATURE, "owl:FunctionalProperty");
        return this.addStatement(RDF.type, (RDFNode)OWL2.FunctionalProperty);
    }

    @Override
    public boolean isBuiltIn() {
        return this.getModel().isBuiltIn(this);
    }

    public Property inModel(Model m) {
        return this.getModel() == m ? this : m.createProperty(this.getURI());
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDataPropertyImpl.getOptionalRootStatement(this, OWL2.DatatypeProperty);
    }

    public int getOrdinal() {
        return OntStatementImpl.createProperty(this.node, this.enhGraph).getOrdinal();
    }
}

