/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Map;
import org.apache.jena.atlas.lib.InternalErrorException;

public class MapWithScope<A, B, S> {
    private final ScopePolicy<A, B, S> scopePolicy;
    private final Allocator<A, B, S> allocator;

    protected MapWithScope(ScopePolicy<A, B, S> scopePolicy, Allocator<A, B, S> allocator) {
        this.scopePolicy = scopePolicy;
        this.allocator = allocator;
    }

    public B get(S scope, A item) {
        if (item == null) {
            throw new InternalErrorException("null in MapWithScope.get(,null)");
        }
        Map<A, B> map = this.scopePolicy.getScope(scope);
        if (map == null) {
            return this.allocator.alloc(scope, item);
        }
        B mappedItem = map.get(item);
        if (mappedItem == null) {
            mappedItem = this.allocator.alloc(scope, item);
            map.put(item, mappedItem);
        }
        return mappedItem;
    }

    public B create() {
        return this.allocator.create();
    }

    public void clear() {
        this.scopePolicy.clear();
        this.allocator.reset();
    }

    public static interface ScopePolicy<A, B, S> {
        public Map<A, B> getScope(S var1);

        public void clear();
    }

    public static interface Allocator<A, B, S> {
        public B alloc(S var1, A var2);

        public B create();

        public void reset();
    }
}

