/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.legacy;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.collection.JenaSet;
import org.apache.jena.mem2.iterator.IteratorOfJenaSets;
import org.apache.jena.mem2.store.legacy.ArrayBunch;
import org.apache.jena.mem2.store.legacy.FieldFilter;
import org.apache.jena.mem2.store.legacy.HashedBunchMap;
import org.apache.jena.mem2.store.legacy.HashedTripleBunch;
import org.apache.jena.mem2.store.legacy.NodeToTriplesMap;
import org.apache.jena.mem2.store.legacy.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class NodeToTriplesMapMem
implements NodeToTriplesMap {
    private final HashedBunchMap bunchMap;
    private final Triple.Field indexField;
    private final Triple.Field f2;
    private final Triple.Field f3;
    private int size = 0;

    public NodeToTriplesMapMem(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        this.indexField = indexField;
        this.f2 = f2;
        this.f3 = f3;
        this.bunchMap = new HashedBunchMap();
    }

    private NodeToTriplesMapMem(NodeToTriplesMapMem mapToCopy) {
        this.indexField = mapToCopy.indexField;
        this.f2 = mapToCopy.f2;
        this.f3 = mapToCopy.f3;
        this.size = mapToCopy.size;
        this.bunchMap = mapToCopy.bunchMap.copy();
    }

    private Node getIndexNode(Triple t) {
        return this.indexField.getField(t);
    }

    @Override
    public void clear() {
        this.bunchMap.clear();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean tryAdd(Triple t) {
        Node node = this.getIndexNode(t);
        TripleBunch s = (TripleBunch)this.bunchMap.get(node);
        if (s == null) {
            s = new ArrayBunch();
            this.bunchMap.put(node, s);
            s.addUnchecked(t);
            ++this.size;
            return true;
        }
        if (s.isArray() && s.size() == 9) {
            s = new HashedTripleBunch(s);
            this.bunchMap.put(node, s);
        }
        if (s.tryAdd(t)) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public void addUnchecked(Triple t) {
        Node node = this.getIndexNode(t);
        TripleBunch s = (TripleBunch)this.bunchMap.get(node);
        if (s == null) {
            s = new ArrayBunch();
            this.bunchMap.put(node, s);
        } else if (s.isArray() && s.size() == 9) {
            s = new HashedTripleBunch(s);
            this.bunchMap.put(node, s);
        }
        s.addUnchecked(t);
        ++this.size;
    }

    @Override
    public boolean tryRemove(Triple t) {
        Node node = this.getIndexNode(t);
        TripleBunch s = (TripleBunch)this.bunchMap.get(node);
        if (s == null) {
            return false;
        }
        if (s.tryRemove(t)) {
            --this.size;
            if (s.isEmpty()) {
                this.bunchMap.removeUnchecked(node);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeUnchecked(Triple t) {
        Node node = this.getIndexNode(t);
        TripleBunch s = (TripleBunch)this.bunchMap.get(node);
        if (s == null) {
            return;
        }
        s.removeUnchecked(t);
        --this.size;
        if (s.isEmpty()) {
            this.bunchMap.removeUnchecked(node);
        }
    }

    @Override
    public ExtendedIterator<Triple> keyIterator() {
        return new IteratorOfJenaSets<Triple>((Iterator<JenaSet<Triple>>)((Object)this.bunchMap.valueIterator()));
    }

    @Override
    public Spliterator<Triple> keySpliterator() {
        return this.keyStream().spliterator();
    }

    @Override
    public Stream<Triple> keyStream() {
        return StreamSupport.stream(this.bunchMap.valueSpliterator(), false).flatMap(bunch -> StreamSupport.stream(bunch.keySpliterator(), false));
    }

    @Override
    public ExtendedIterator<Triple> iteratorForMatches(Node index, Node n2, Node n3) {
        TripleBunch s = (TripleBunch)this.bunchMap.get(index);
        if (s == null) {
            return NullIterator.instance();
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        return filter.hasFilter() ? s.keyIterator().filterKeep(filter.getFilter()) : s.keyIterator();
    }

    @Override
    public Stream<Triple> streamForMatches(Node index, Node n2, Node n3) {
        TripleBunch s = (TripleBunch)this.bunchMap.get(index);
        if (s == null) {
            return Stream.empty();
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        return filter.hasFilter() ? StreamSupport.stream(s.keySpliterator(), false).filter(filter.getFilter()) : StreamSupport.stream(s.keySpliterator(), false);
    }

    @Override
    public boolean containsMatch(Node index, Node n2, Node n3) {
        TripleBunch s = (TripleBunch)this.bunchMap.get(index);
        if (s == null) {
            return false;
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        if (!filter.hasFilter()) {
            return true;
        }
        return s.anyMatch(filter.getFilter());
    }

    @Override
    public NodeToTriplesMapMem copy() {
        return new NodeToTriplesMapMem(this);
    }

    @Override
    public boolean containsKey(Triple triple) {
        TripleBunch s = (TripleBunch)this.bunchMap.get(this.getIndexNode(triple));
        if (s == null) {
            return false;
        }
        return s.containsKey(triple);
    }

    @Override
    public boolean anyMatch(Predicate<Triple> predicate) {
        return this.bunchMap.valueStream().anyMatch((? super T bunch) -> bunch.anyMatch(predicate));
    }
}

