package org.apache.maven.plugin.coreit;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

import java.util.Properties;
import java.io.FileOutputStream;
import java.io.File;

/**
 * Take some configuration values that use interpolated POM values and write them to a properties file
 * to make sure they are passing through the system properly. We have reports (MNG-1927) that we're
 * 
 * @goal generate-properties
 */
public class InterpolatedPomConfigurationMojo
    extends AbstractMojo
{
    /**
     * @parameter expression="${basedir}"
     */
    private String basedir;

    /**
     * @parameter expression="${projectBuildDirectory}"
     */
    private String projectBuildDirectory;

    /**
     * @parameter expression="${targetDirectoryString}"
     */
    private String targetDirectoryString;

    /**
     * @parameter expression="${targetDirectoryFile}"
     */
    private File targetDirectoryFile;

    public void execute()
        throws MojoExecutionException
    {
        try
        {
            Properties mojoGeneratedPropeties = new Properties();

            mojoGeneratedPropeties.put( "project.build.directory", projectBuildDirectory );
            if ( targetDirectoryString != null )
            {
                mojoGeneratedPropeties.put( "targetDirectoryString", targetDirectoryString );
            }    
            if ( targetDirectoryFile != null )
            {
                mojoGeneratedPropeties.put( "targetDirectoryFile", targetDirectoryFile.getAbsolutePath() );
            }    

            FileOutputStream fos = new FileOutputStream( new File( basedir, "target/mojo-generated.properties" ) );

            mojoGeneratedPropeties.store( fos, "# Properties generated by the execution of a mojo that uses interpolated POM values for configuration." );
        }
        catch( Exception e )
        {
            getLog().error( "Error creating mojo generated properties.", e );
        }
    }
}
