/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import org.mvndaemon.mvnd.common.DaemonExpirationStatus;

public class DaemonStopEvent
implements Serializable {
    private final String daemonId;
    private final long timestamp;
    private final DaemonExpirationStatus status;
    private final String reason;

    public DaemonStopEvent(String daemonId, long timestamp, DaemonExpirationStatus status, String reason) {
        this.daemonId = daemonId;
        this.timestamp = timestamp;
        this.status = status;
        this.reason = reason != null ? reason : "";
    }

    public String getDaemonId() {
        return this.daemonId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public DaemonExpirationStatus getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonStopEvent that = (DaemonStopEvent)o;
        return Objects.equals(this.daemonId, that.daemonId) && this.timestamp == that.timestamp && this.status == that.status && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.daemonId, this.status, this.reason});
    }

    public String toString() {
        return "DaemonStopEvent{daemonId=" + this.daemonId + ", timestamp=" + DateFormat.getDateTimeInstance().format(new Date(this.timestamp)) + ", status=" + String.valueOf((Object)this.status) + ", reason=" + this.reason + "}";
    }
}

