/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.slf4j.Logger;

public class SftpServerSubSystemEventListener
extends ServerEventListenerHelper
implements SftpEventListener {
    public SftpServerSubSystemEventListener(Logger logger) {
        super("sftp", logger);
    }

    public void initialized(ServerSession session, int version) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Session {} initialized - version={}", (Object)session, (Object)version);
        }
    }

    public void destroying(ServerSession session) throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Session destroyed: {}", (Object)session);
        }
    }

    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (thrown == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Session {} created directory {} with attributes={}", new Object[]{session, path, attrs});
            }
        } else {
            this.log.error("Failed ({}) to create directory {} in session {}: {}", new Object[]{thrown.getClass().getSimpleName(), path, session, thrown.getMessage()});
        }
    }

    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        if (thrown == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Session {} moved {} to {} with options={}", new Object[]{session, srcPath, dstPath, opts});
            }
        } else {
            this.log.error("Failed ({}) to move {} to {} using options={} in session {}: {}", new Object[]{thrown.getClass().getSimpleName(), srcPath, dstPath, opts, session, thrown.getMessage()});
        }
    }

    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) throws IOException {
        if (thrown == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Session {} removed {}", (Object)session, (Object)path);
            }
        } else {
            this.log.error("Failed ({}) to remove {} in session {}: {}", new Object[]{thrown.getClass().getSimpleName(), path, session, thrown.getMessage()});
        }
    }
}

