/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.controller.queue.FlowFileSummary;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;

public class ListFlowFileRequest
implements ListFlowFileStatus {
    private final String requestId;
    private final int maxResults;
    private final QueueSize queueSize;
    private final long submissionTime = System.currentTimeMillis();
    private final List<FlowFileSummary> flowFileSummaries = new ArrayList<FlowFileSummary>();
    private ListFlowFileState state = ListFlowFileState.WAITING_FOR_LOCK;
    private String failureReason;
    private long lastUpdated = System.currentTimeMillis();

    public ListFlowFileRequest(String requestId, int maxResults, QueueSize queueSize) {
        this.requestId = requestId;
        this.maxResults = maxResults;
        this.queueSize = queueSize;
    }

    public String getRequestIdentifier() {
        return this.requestId;
    }

    public long getRequestSubmissionTime() {
        return this.submissionTime;
    }

    public synchronized long getLastUpdated() {
        return this.lastUpdated;
    }

    public synchronized ListFlowFileState getState() {
        return this.state;
    }

    public synchronized String getFailureReason() {
        return this.failureReason;
    }

    public synchronized void setState(ListFlowFileState state) {
        this.state = state;
        this.lastUpdated = System.currentTimeMillis();
    }

    public synchronized void setFailure(String explanation) {
        this.state = ListFlowFileState.FAILURE;
        this.failureReason = explanation;
        this.lastUpdated = System.currentTimeMillis();
    }

    public synchronized List<FlowFileSummary> getFlowFileSummaries() {
        return Collections.unmodifiableList(this.flowFileSummaries);
    }

    public synchronized void setFlowFileSummaries(List<FlowFileSummary> summaries) {
        this.flowFileSummaries.clear();
        this.flowFileSummaries.addAll(summaries);
        this.lastUpdated = System.currentTimeMillis();
    }

    public QueueSize getQueueSize() {
        return this.queueSize;
    }

    public synchronized boolean cancel() {
        if (this.state == ListFlowFileState.COMPLETE || this.state == ListFlowFileState.CANCELED) {
            return false;
        }
        this.state = ListFlowFileState.CANCELED;
        return true;
    }

    public synchronized int getCompletionPercentage() {
        return this.state == ListFlowFileState.COMPLETE ? 100 : 0;
    }

    public int getMaxResults() {
        return this.maxResults;
    }
}

