/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.LegacyESVersion;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.MasterNodeReadRequest;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.Priority;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;

public class ClusterHealthRequest
extends MasterNodeReadRequest<ClusterHealthRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandHidden();
    private TimeValue timeout = new TimeValue(30L, TimeUnit.SECONDS);
    private ClusterHealthStatus waitForStatus;
    private boolean waitForNoRelocatingShards = false;
    private boolean waitForNoInitializingShards = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;
    private String waitForNodes = "";
    private Priority waitForEvents = null;
    private Level level = Level.CLUSTER;

    public ClusterHealthRequest() {
    }

    public ClusterHealthRequest(String ... indices) {
        this.indices = indices;
    }

    public ClusterHealthRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.timeout = in.readTimeValue();
        if (in.readBoolean()) {
            this.waitForStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.waitForNoRelocatingShards = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.waitForNodes = in.readString();
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
        if (in.getVersion().onOrAfter(LegacyESVersion.V_6_2_0)) {
            this.waitForNoInitializingShards = in.readBoolean();
        }
        this.indicesOptions = in.getVersion().onOrAfter(LegacyESVersion.V_7_2_0) ? IndicesOptions.readIndicesOptions(in) : IndicesOptions.lenientExpandOpen();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.indices);
        }
        out.writeTimeValue(this.timeout);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeBoolean(this.waitForNoRelocatingShards);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.waitForNodes);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_6_2_0)) {
            out.writeBoolean(this.waitForNoInitializingShards);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_2_0)) {
            this.indicesOptions.writeIndicesOptions(out);
        }
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterHealthRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterHealthRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.masterNodeTimeout == DEFAULT_MASTER_NODE_TIMEOUT) {
            this.masterNodeTimeout = timeout;
        }
        return this;
    }

    public ClusterHealthRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public ClusterHealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(ClusterHealthStatus waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(ClusterHealthStatus.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    public boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    public ClusterHealthRequest waitForNoRelocatingShards(boolean waitForNoRelocatingShards) {
        this.waitForNoRelocatingShards = waitForNoRelocatingShards;
        return this;
    }

    public boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    public ClusterHealthRequest waitForNoInitializingShards(boolean waitForNoInitializingShards) {
        this.waitForNoInitializingShards = waitForNoInitializingShards;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards.equals(ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        return this;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    public void level(Level level) {
        this.level = Objects.requireNonNull(level, "level must not be null");
    }

    public Level level() {
        return this.level;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public static enum Level {
        CLUSTER,
        INDICES,
        SHARDS;

    }
}

