/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.arc;

import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FiledescRecord {
    private static final Logger LOG = Logger.getLogger(FiledescRecord.class.getName());
    private int majorVersion;
    private int minorVersion;
    private String organization;
    private String format;
    private JSONObject metadata;

    public boolean hasMetaData() {
        return this.metadata != null;
    }

    public int getMetaDataCount() {
        try {
            return this.metadata == null ? 0 : this.metadata.getJSONArray("MetaData").length();
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
            return 0;
        }
    }

    public void addMetaData(String name, String value) {
        if (this.metadata == null) {
            this.metadata = new JSONObject();
        }
        try {
            JSONObject jo = new JSONObject();
            jo.put("name", (Object)name);
            jo.put("value", (Object)value);
            this.metadata.append("MetaData", (Object)jo);
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
    }

    public String getMetaDataName(int i) {
        return this.getMetaDataField(i, "name");
    }

    public String getMetaDataValue(int i) {
        return this.getMetaDataField(i, "value");
    }

    public String getMetaDataField(int i, String field) {
        try {
            JSONObject jo;
            JSONArray a;
            if (this.metadata != null && i < (a = this.metadata.getJSONArray("MetaData")).length() && (jo = a.getJSONObject(i)) != null) {
                return jo.getString(field);
            }
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return null;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

